% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AdjBQR.R
\name{li_powell}
\alias{li_powell}
\title{Asymmetric-Laplace-type Working Likelihood For Cenaored Quantile Regression}
\usage{
li_powell(pars, y, x, tau, sig)
}
\arguments{
\item{pars}{regression coefficient vector}

\item{y}{the response vector}

\item{x}{the design matrix with one in the first column corresponding to the intercept}

\item{tau}{the quantile level}

\item{sig}{scale parameter sigma}
}
\value{
the working log (asymmetric Laplace-type) likelihood function (the part involving the regression coefficients)
}
\description{
Asymmetric-Laplace-type working likelihood for linear
quantile regression with responses
subject to left censoring at zero
}
\details{
The asymmetric-Laplace-type working likelihood is proportional to exponential
of the negative Powell objective function for censored quantile regression
}
\references{
Powell, J. L. (1986). Censored regression quantiles. Journal of Econometrics, 32, 143-155.

Yang, Y., Wang, H. and He, X. (2015). Posterior inference in Bayesian quantile regression with asymmetric Laplace
  likelihood. International Statistical Review, 2015. doi: 10.1111/insr.12114.
}

