% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADWGS_test.R
\name{ADWGS_test}
\alias{ADWGS_test}
\title{ADWGS_test executes the statistical test for ActiveDriverWGS}
\usage{
ADWGS_test(id, gr_element_coords, gr_site_coords, gr_maf, win_size,
  element_bias = T)
}
\arguments{
\item{id}{A string used to identify the element of interest. \code{id}
corresponds to an element in the id column of the elements file}

\item{gr_element_coords}{A GenomicRanges object that describes the elements of interest containing the
chromosome, start and end coordinates, and an mcols column corresponding to id}

\item{gr_site_coords}{A GenomicRanges object that describes the sites of interest which reside
in the elements of interest containing the chromosome, start and end coordinates,
and an mcols column corresponding to id. Examples of sites include transcription factor binding
sites in promoter regions or phosphosites in exons of protein coding genes. An empty GenomicRanges object
nullifies the requirement for sites to exist.}

\item{gr_maf}{A GenomicRanges object that describes the mutations in the dataset containing the chromosome,
start and end coordinates, patient id, and trinucleotide context}

\item{win_size}{An integer indicating the size of the background window in base pairs for which the
mutation rate is expected to remain the same. The default is 50000bps.}

\item{element_bias}{A boolean indicating whether or not indels should be counted by their midpoints
or with bias towards the element}
}
\value{
A data frame containing the following columns
\describe{
    \item{id}{A string identifying the element of interest}
    \item{pp_element}{The p-value of the element}
    \item{element_muts_obs}{The number of patients with a mutation in the element}
    \item{element_muts_exp}{The expected number of patients with a mutation in the element with respect to background}
    \item{element_enriched}{A boolean indicating whether the element is enriched in mutations}
    \item{pp_site}{The p-value of the site}
    \item{site_muts_obs}{The number of patients with a mutation in the site}
    \item{site_muts_exp}{The expected number of patients with a mutation in the site with respect to element}
    \item{site_enriched}{A boolean indicating whether the site is enriched in mutations}
    \item{result_number}{A numeric indicator denoting the order in which the results were calculated}
    \item{fdr_element}{The FDR corrected p-value of the element}
    \item{fdr_site}{The FDR corrected p-value of the site}
    \item{has_site_mutations}{A V indicates the presence of site mutations}
}
}
\description{
ADWGS_test executes the statistical test for ActiveDriverWGS
}
\examples{
\donttest{
library(GenomicRanges)

# Regions
data(cancer_genes)
gr_element_coords = GRanges(seqnames = cancer_genes$chr,
IRanges(start = cancer_genes$start, end = cancer_genes$end),
mcols = cancer_genes$id)

# Sites (NULL)
gr_site_coords = GRanges(c(seqnames=NULL,ranges=NULL,strand=NULL))

# Mutations
data(cll_mutations)
cll_mutations = format_muts(cll_mutations)

gr_maf = GRanges(cll_mutations$chr,
IRanges(cll_mutations$pos1, cll_mutations$pos2),
mcols=cll_mutations[,c("patient", "tag")])

# ADWGS_test
id = "ATM"
result = ADWGS_test(id, gr_element_coords, gr_site_coords, gr_maf, 50000)
}
}
