% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragmentation.R
\name{fragmentation}
\alias{fragmentation}
\title{Fragmentation Metrics}
\usage{
fragmentation(x, w, thresh, bout.length = 1, metrics = c("mean_bout",
  "TP", "Gini", "power", "hazard", "all"))
}
\arguments{
\item{x}{\code{integer} \code{vector} of activity data.}

\item{w}{\code{vector} of wear flag data with same dimension as \code{x}.}

\item{thresh}{threshold to binarize the data.}

\item{bout.length}{minimum duration of defining an active bout; defaults to 1.}

\item{metrics}{What is the fragmentation metrics to exract. Can be
"mean_bout","TP","Gini","power","hazard",or all the above metrics "all".}
}
\value{
A list with elements
\item{mean_r}{mean sedentary bout duration}
\item{mean_a}{mean active bout duration}
\item{SATP}{sedentary to active transition probability}
\item{ASTP}{bactive to sedentary transition probability}
\item{Gini_r}{Gini index for active bout}
\item{Gini_a}{Gini index for sedentary bout}
\item{h_r}{hazard function for sedentary bout}
\item{h_a}{hazard function for active bout}
\item{alpha_r}{power law parameter for sedentary bout}
\item{alpha_a}{power law parameter for active bout}
}
\description{
Fragmentation methods to study the transition between two states, e.g.
sedentary v.s. active.
}
\details{
Metrics include
mean_bout (mean bout duration),
TP (between states transition probability),
Gini (gini index),
power (alapha parameter for power law distribution),
hazard (average hazard function)
}
\examples{
data(example_activity_data)
count1 = c(t(example_activity_data$count[1,-c(1,2)]))
wear1 = c(t(example_activity_data$wear[1,-c(1,2)]))
frag = fragmentation(x = count1, w = wear1, thresh = 100, bout.length = 1, metrics = "mean_bout")


}
\references{
Junrui Di, Andrew Leroux, Jacek Urbanek, Ravi Varadhan, Adam P. Spira, Jennifer Schrack, Vadim Zipunnikov.
Patterns of sedentary and active time accumulation are associated with mortality in US adults: The NHANES study. bioRxiv 182337; doi: https://doi.org/10.1101/182337
}
