% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{lrt.B}
\alias{lrt.B}
\title{likelihood ratio test for two models based on kstest.B}
\usage{
lrt.B(d1, d2, parallel = FALSE)
}
\arguments{
\item{d1}{An object of class 'kstest.B'.}

\item{d2}{An object of class 'kstest.B'.}

\item{parallel}{Whether to use multiple threads to paralleling computation. Default is FALSE. Please aware that it may take longer time to execute the program with parallel=FALSE.}
}
\value{
The p-value of the likelihood ratio test.
}
\description{
Conduct likelihood ratio test for comparing two different models.
}
\details{
If the pvalue of d1 and d2 are greater than the user-specified significance level, which indicates that the original data x may come from the two distributions in d1 and d2, a likelihood ratio test is desired to choose a more 'possible' distribution based on the current data.
NOTE that the x in d1 and d2 must be IDENTICAL! Besides, NOTE that the dist in d1 and d2 must be DIFFERENT!
The dist inherited from d1 is the null distribution and that from d2 is used as the alternative distribution.

If the output p-value smaller than the user-specified significance level, the dist of d2 is more appropriate for modeling x.
Otherwise, There is no significant difference between dist of d1 and dist of d2, given the current data.
}
\examples{
set.seed(234)
x=sample.zi1(2000,phi=0.3,dist='bb',n=10,alpha1=2,alpha2=4)
\donttest{d1=kstest.B(x,nsim=100,bootstrap=TRUE,dist='zibb',lowerbound=1e-10,upperbound =100000)}
\donttest{d2=kstest.B(x,nsim=100,bootstrap=TRUE,dist='zibnb',lowerbound=1e-10,upperbound=100000)}
\donttest{lrt.B(d1,d2)} #0.58
}
\seealso{
\link[AZIAD]{lrt.A}
}
