% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_model.R
\name{create_model_Unscaled}
\alias{create_model_Unscaled}
\title{Initialize an ATN model, following Binzer et al. 2016, Global Change Biology}
\usage{
create_model_Unscaled(nb_s, nb_b, BM, fw)
}
\arguments{
\item{nb_s}{integer, number of total species.}

\item{nb_b}{integer, number of basal species.}

\item{BM}{float vector, body mass of species.}

\item{fw}{binary adjacency matrix of the food web.}
}
\value{
An object of class \emph{ATN (Rcpp_parameters_prefs)}.
}
\description{
Initialize an ATN model, following Binzer et al. 2016, Global Change Biology
}
\details{
A model is defined by the total number of species
(\emph{nb_s}), the number of basal species (\emph{nb_b}),
the number of nutrients (\emph{nb_n}), the body masses
 (\emph{BM}) of species, and the adjacency matrix (\emph{fw})
 representing species interactions.
}
\examples{
library(ATNr)
set.seed(123)
n_species <- 50
n_basal <- 20
masses <- sort(10^runif(n_species, 1, 6)) #body mass of species
L <- create_Lmatrix(masses, n_basal)
fw <- L
fw[fw > 0] <- 1
mod <- create_model_Unscaled(n_species, n_basal, masses, fw)
}
\references{
Binzer, A., Guill, C., Rall, B.C. and Brose, U. (2016),
Interactive effects of warming, eutrophication and size structure: impacts on biodiversity and food-web structure.
Glob Change Biol, 22: 220-227. https://doi.org/10.1111/gcb.13086
Gauzens, B., Rall, B.C., Mendonca, V. et al.
Biodiversity of intertidal food webs in response to warming across latitudes.
Nat. Clim. Chang. 10, 264-269 (2020). https://doi.org/10.1038/s41558-020-0698-z
}
