% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jacobian.R
\name{Joacobian}
\alias{Joacobian}
\title{Estimate the Jacobian matrix of a ODE system}
\usage{
Joacobian(bioms, ODE, eps = 1e-08)
}
\arguments{
\item{bioms}{float vector, biomass of species.}

\item{ODE}{function that computes the ODEs from one of the model available}

\item{eps}{float, scale precision of the numerical approximation.}
}
\value{
A matrix corresponding to the Jacobian  of the system estimated at the parameter biomasses
}
\description{
Estimate the Jacobian matrix of a ODE system
}
\details{
The function provides a numerical estimation of the Jacobian matrix
based on the 5 points stencil method. The precision of the method is in  \deqn{O(h^5)},
where \deqn{h = eps*bioms}. The choice of eps should ensure that \deqn{h^5}
is always lower to the extinction threshold.

The dimension of the Jacobian matrix are not always matching the number of species in the system.
This is because we considered that a perturbation can not correspond to the recolonisation of an extinct species.
Therefore, extinct species are removed from the system to calculate the Jacobian matrix.
}
