% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machine_learning.R
\name{AStrain.as_data}
\alias{AStrain.as_data}
\title{Training models for posterior selection of algorithms}
\usage{
\method{AStrain}{as_data}(data_object, method = NULL, parallel = FALSE, f = NULL, ...)
}
\arguments{
\item{data_object}{object of class \code{as_data}.}

\item{method}{name of the model to be used. The user can choose from any of the models provided by \code{caret}. See \url{http://topepo.github.io/caret/train-models-by-tag.html} for more information about the models supported.}

\item{parallel}{boolean to control whether to parallelise the training or not (paralellization is handled by library snow).}

\item{f}{function we want to use to train the models. If NULL, \code{caret}'s function will be used.}

\item{...}{arguments passed to the caret train function.}
}
\value{
A list is returned of class \code{as_train} containing the trained models, one for each of the algorithms.
}
\description{
For each algorithm (column) in the data, a model is trained to later predict the output (KPI) for that algorithm (using function \code{ASpredict()}).
}
\examples{
data(branchingsmall)
data_object <- partition_and_normalize(branchingsmall$x, branchingsmall$y, test_size = 0.3,
family_column = 1, split_by_family = TRUE)
training <- AStrain(data_object, method = "glm")
custom_function <- function(x, y) {
  glm.fit(x, y)
}
custom_training <- AStrain(data_object, f = "custom_function")
}
