% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msavi.R
\name{msavi}
\alias{msavi}
\title{Modified soil adjusted vegetation index}
\usage{
msavi(directory = getwd(), crop = "n", ext2crop = "none")
}
\arguments{
\item{ext2crop, crop, directory}{Same as mentioned in \code{\link[ASIP]{arvi}}.}
}
\value{
File named msavi_'date of satellite image acqisition'.tif in the input folder
}
\description{
Modified Soil Adjusted Vegetation Index (MSAVI) is a vegetation index.
Advantage of this index is that, it increases the dynamic range of the vegetation signal while further minimizing the soil background influences,
resulting in greater vegetation sensitivity as defined by a 'vegetation signal' to 'soil noise' ratio.
}
\note{
1. MSAVI=((2r_nir + 1) - ((2r_nir + 1)^2 - 8(r_nir - r_red))^0.5)/2

where, "r_" denotes TOA reflectance band.

Other important notes are mentioned in \code{\link[ASIP]{custom.eqn}}.
}
\examples{
library (raster)
library (rgdal)
# Finding the path of the sample satellite image directory.
# User may define paths directly like "/home/ur_folder" or "C:/ur_folder"
path <- system.file ("TM_sample", package = "ASIP")
shapefil <- paste0 (path, "/test.shp")
msavi (directory = path, crop = "y", ext2crop = shapefil)
}
\references{
\href{http://www.sciencedirect.com/science/article/pii/0034425794901341}{Qi J, Chehbouni A, Huete A R, Kerr Y, Sorooshian S (1994) A modified soil adjusted vegetation index. Remote Sensing of Environment, 48 (2), pp: 119-126. doi:10.1016/0034-4257(94)90134-1.}
}
