% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resASICS-class.R
\docType{methods}
\name{resASICS-methods}
\alias{resASICS-methods}
\alias{summary,resASICS-method}
\alias{summary.resASICS}
\alias{show,resASICS-method}
\alias{show.resASICS}
\alias{print,resASICS-method}
\alias{print.resASICS}
\alias{plot,resASICS-method}
\alias{plot.resASICS}
\title{S4 methods to represent results of ASICS.}
\usage{
\S4method{summary}{resASICS}(object, ...)

\S4method{show}{resASICS}(object)

\S4method{print}{resASICS}(x)

\S4method{plot}{resASICS}(x, y, xmin = 0.5, xmax = 10, ymin = 0,
  ymax = NULL, add_metab = NULL)
}
\arguments{
\item{object}{an object of class resASICS}

\item{...}{not used}

\item{x}{an object of class resASICS}

\item{y}{not used}

\item{xmin, xmax, ymin, ymax}{lower and upper bounds for x and y, respectively}

\item{add_metab}{name of one metabolite to add to the plot. Default to
\code{NULL} (no pure spectrum added to the plot)}
}
\value{
plot the true and recomposed (as estimated by \code{\link{ASICS}})
spectra on one figure. In addition, one pure metabolite spectrum (as
provided in the reference library) can be superimposed to the plot.
}
\description{
S4 methods to represent results of ASICS.
}
\examples{
\dontshow{
lib_file <- system.file("extdata", "library_for_examples.rda",
                        package = "ASICS")
cur_path <- system.file("extdata", "example_spectra", "AG_faq_Beck01",
                        package = "ASICS")
to_exclude <- matrix(c(4.5,5.1,5.5,6.5), ncol = 2, byrow = TRUE)
result <- ASICS(path = cur_path, exclusion.areas = to_exclude,
                nb.iter.signif = 10, library.metabolites = lib_file)

#Results of ASICS
result
summary(result)
plot(result)

}
\dontrun{
cur_path <- system.file("extdata", "example_spectra", "AG_faq_Beck01",
                        package = "ASICS")
to_exclude <- matrix(c(4.5,5.1,5.5,6.5), ncol = 2, byrow = TRUE)
result <- ASICS(path = cur_path, exclusion.areas = to_exclude)

result
summary(result)
plot(result)

}
}
\seealso{
\code{\link{ASICS}} \code{\link{resASICS-class}}
}
