% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registry_KNN_dist.R
\name{registry_KNN_dist}
\alias{registry_KNN_dist}
\title{Identifies the K-nearest-neighbours (stations) to all the monitoring sites included in a given ARPALdf
registry data.frame. The neighbours are identified computing the Euclidean distance among the sites'
coordinates.}
\usage{
registry_KNN_dist(reg_X, reg_Y, k = 1)
}
\arguments{
\item{reg_X}{Dataset of class 'ARPALdf' containing the stations list obtained as registry
(from 'get_ARPA_Lombardia_xxx_registry' command). The object must contain the following
colums: 'IDStation','NameStation','Longitude' and 'Latitude'.}

\item{reg_Y}{Dataset of class 'ARPALdf' containing the stations list obtained as registry
(from 'get_ARPA_Lombardia_xxx_registry' command). The object must contain the following
colums: 'IDStation','NameStation','Longitude' and 'Latitude'.}

\item{k}{Integer value. Represents the number of neighbours the user wants to identify.}
}
\value{
A data.frame object having the same length of reg_X. For each row (stations in reg_X)
it contains the name and the IDStation code for the k-nearest neighbours.
}
\description{
# For each element included in reg_X, it dentifies the k-nearest neighbours locations
(among those included in reg_Y) according to an Euclidean distance metric. reg_X and reg_Y
must be two 'ARPALdf' objects obtained using get_ARPA_Lombardia_xxx_registry'.
}
\examples{
library(tidyverse)
regAQ <- get_ARPA_Lombardia_AQ_registry()
regAQ <- regAQ \%>\% filter(Pollutant \%in\% c("PM10","Ammonia"))
regW <- get_ARPA_Lombardia_W_registry()
registry_KNN_dist(regAQ,regW,k=2)

}
