% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARI.R
\name{ARI}
\alias{ARI}
\title{Valid Circular Inference (ARI) for Brain Imaging}
\usage{
ARI(Pmap, clusters, mask = NULL, alpha = 0.05, Statmap = function(ix)
  -qnorm(Pmap[ix]), summary_stat = c("max", "center-of-mass"),
  silent = FALSE)
}
\arguments{
\item{Pmap}{3D array of p-values or a (character) nifti file name.}

\item{clusters}{3D array of cluster ids (0 when voxel does not belong to any cluster)
or a (character) nifti file name.}

\item{mask}{3D array of locicals (i.e. \code{TRUE}/\code{FALSE} in/out of the brain). Alternatively 
it may be a (character) nifti file name. If \code{mask=NULL}, it is assumed that non of the voxels have to be excluded.}

\item{alpha}{Significance level. \code{alpha=.05} by default.}

\item{Statmap}{Statistics (usually t-values) on which the summaries are based. Can be either
a 3D array, a (character) nifti file name or a function with argument \code{ix} used in the function to select the voxels belonging to a given cluster.
By default \code{Statmap = function(ix) -qnorm(Pmap[ix])} which convert the p-values in one-sided z-score.}

\item{summary_stat}{Choose among \code{=c("max", "center-of-mass")}.}

\item{silent}{\code{FALSE} by default.}
}
\value{
A \code{matrix} reporting Size, FalseNull,  TrueNull, ActiveProp and other statistics for each cluster.
}
\description{
Valid Circular Inference (ARI) for Brain Imaging
}
\examples{
pvalue_name <- system.file("extdata", "pvalue.nii.gz", package="ARIbrain")
cluster_name <- system.file("extdata", "cluster_th_3.2.nii.gz", package="ARIbrain")
zstat_name <- system.file("extdata", "zstat.nii.gz", package="ARIbrain")
mask_name <- system.file("extdata", "mask.nii.gz", package="ARIbrain")

print(mask_name)
print(pvalue_name)
print(cluster_name)
print(zstat_name)

ARI(Pmap = pvalue_name, clusters= cluster_name, 
    mask=mask_name, Statmap = zstat_name)
    
}
