% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{parse_order}
\alias{parse_order}
\title{Order parser}
\usage{
parse_order(orders, order_name, kz, restriction = FALSE)
}
\arguments{
\item{orders}{A numeric vector of the same length as the total number of
variables (excluding the fixed ones). If the input is \code{order} or
\code{max_order} it should only contain positive integers or 0. If the
input is \code{fixed_order} it should also contain the value '-1'
indicating that a specific order should not be fixed. An integer could be
provided if all variables are of the same order (or all '-1' in the case of
\code{fixed_order}).}

\item{order_name}{The name of the function argument that is passed into
\code{order}.}

\item{kz}{An integer. The number of dependent and independent variables.}

\item{restriction}{When the input in \code{orders} is either \code{order} or
\code{max_order} it should be \code{FALSE} (default). When the input is
\code{fixed_order} it should be '-1' indicating that the input in
\code{orders} is a restriction for the 'order' of the model (either upper
bound or fixed order).}
}
\value{
A numeric vector of the same length as the total number of variables
  (excluding the fixed ones).
}
\description{
It parses the order and checks the integrity of the order input.
}
\seealso{
\code{\link{parse_formula}}
}
\author{
Kleanthis Natsiopoulos, \email{klnatsio@gmail.com}
}
\keyword{internal}
