AAZ19<-function(type="Normal",stype="unknown",INSL="II",LOTS="2-8",AQL="1.0"){
  newvalue<-NULL
  op <- options(changedop=newvalue)
  message("ANSI/ASQ Z1.9 converted from MIL-STD-414 using Gasciogne Method")
  dINSL <- menu(c("S-3", "S-4","I", "II", "III"), title = "\nWhat is the Inspection Level?")
  INSL
  # Get the lot size
  dLOTS <- menu(c("2-8", "9-15", "16-25", "26-50",
                  "51-90", "91-150", "151-280", "281-400",
                  "401-500", "501-1200", "1201-3200","3201-10,000",
                  "10,001-35,000", "35,001-150,000", "150,001-500,000",
                  "500,001 and over"), title = "\nWhat is the Lot Size?")
  LOTS
  # Get the AQL
  dAQL <- menu(c("0.10","0.15","0.25",
                 "0.40","0.65","1.0","1.5","2.5","4.0","6.5","10"),
               title = "\nWhat is the AQL in percent nonconforming per 100 items?")
  AQL
  #Create matrix of Code Letters
  codes<-c("B","C","D","E","F","G","H","I","J","K","L","M","N","P")
  InspLev<-c("S-3","S-4","I","II","III")
  LotSize<-c("2-8", "9-15", "16-25", "26-50","51-90", "91-150", "151-280", "281-400","401-500", "501-1200", "1201-3200","3201-10,000","10,001-35,000", "35,001-150,000", "150,001-500,000","500,001 and over")
  aql<-c("0.10","0.15","0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5","10")
  letters<-c("B","B","B","B","C",
             "B","B","B","B","D",
             "B","B","B","C","E",
             "B","B","C","D","F",
             "B","B","D","E","G",
             "B","C","E","F","H",
             "B","D","F","G","I",
             "C","E","G","H","J",
             "C","E","G","I","J",
             "D","F","H","J","K",
             "E","G","I","K","L",
             "F","H","J","L","M",
             "G","I","K","M","N",
             "H","J","L","N","P",
             "H","K","M","P","P",
             "H","K","N","P","P")
  SSCodeLetters<-matrix(letters,nrow=16, byrow=TRUE)
  rownames(SSCodeLetters)<-LotSize
  colnames(SSCodeLetters)<-InspLev
  # get the code letter
  Codeletter<-SSCodeLetters[dLOTS,dINSL]

  while(stype=="unknown") {

  #Create Matrix of M values for Normal and Tightened Sampling standard deviation unknown
  temp<-array(c(0.077,0.077,0.077,0.077,0.077,0.186,0.228,0.250,0.253,0.243,0.225,0.218,0.202,0.204,
                0.005,0.005,0.005,0.005,0.179,0.311,0.356,0.378,0.373,0.355,0.326,0.315,0.292,0.294,
                0.087,0.087,0.087,0.087,0.349,0.491,0.531,0.551,0.534,0.503,0.461,0.444,0.412,0.414,
                0.421,0.421,0.421,0.421,0.714,0.839,0.864,0.874,0.833,0.778,0.711,0.684,0.636,0.637,
                0.041,0.041,0.041,1.050,1.270,1.330,1.330,1.320,1.240,1.160,1.060,1.020,0.946,0.945,
                1.340,1.340,1.340,2.130,2.140,2.090,2.030,2.000,1.870,1.730,1.590,1.520,1.420,1.420,
                1.490,1.490,3.330,3.540,3.270,3.060,2.930,2.860,2.660,2.470,2.270,2.180,2.050,2.040,
                5.460,5.460,5.820,5.340,4.720,4.320,4.100,3.970,3.700,3.440,3.170,3.060,2.880,2.860,
                7.590,10.88,9.800,8.400,7.260,6.550,6.180,5.980,5.580,5.210,4.830,4.670,4.420,4.390,
                18.86,16.41,14.37,12.19,10.53,9.480,8.950,8.650,8.110,7.610,7.100,6.880,6.560,6.520,
                26.94,22.84,20.19,17.34,15.17,13.74,13.01,12.60,11.89,11.23,10.58,10.29,9.860,9.800,
                33.69,29.43,26.55,23.30,20.73,18.97,18.07,17.55,16.67,15.87,15.07,14.71,14.18,14.11),
              dim=c(14,12))
  ANSIASQZ19M <- temp
  rownames(ANSIASQZ19M)<-codes
  #Create Matrix of M values for Reduced Sampling standard deviation unknown
  temp<-array(c(0.087,0.087,0.087,0.087,0.087,0.087,0.087,0.349,0.491,0.531,0.551,0.567,0.503,0.461,
                0.421,0.421,0.421,0.421,0.421,0.421,0.421,0.714,0.839,0.864,0.874,0.885,0.778,0.711,
                0.041,0.041,0.041,0.041,0.041,0.041,1.060,1.270,1.330,1.330,1.320,1.320,1.160,1.060,
                1.340,1.340,1.340,1.340,1.340,1.340,2.130,2.140,2.090,2.030,2.000,1.980,1.730,1.590,
                1.490,1.490,1.490,1.490,1.490,3.330,3.540,3.270,3.060,2.930,2.860,2.820,2.470,2.270,
                5.460,5.460,5.460,5.460,5.460,5.820,5.340,4.720,4.320,4.100,3.970,3.910,3.440,3.170,
                7.590,7.590,7.590,7.590,10.88,9.800,8.400,7.260,6.550,6.180,5.980,5.870,5.210,4.830,
                18.86,18.86,18.86,18.86,16.41,14.37,12.19,10.53,9.480,8.950,8.650,8.480,7.610,7.100,
                26.94,26.94,26.94,26.94,22.84,20.19,17.34,15.17,13.74,13.01,12.60,12.37,11.23,10.58,
                33.69,33.69,33.69,33.69,29.43,26.55,23.30,20.73,18.97,18.07,17.55,17.25,15.87,15.07,
                40.47,40.47,40.47,40.47,36.79,33.94,30.50,27.65,25.63,24.58,23.97,23.61,21.99,21.05),
              dim=c(14,11))
  ANSIASQZ19RM<-temp
  rownames(ANSIASQZ19RM)<-codes
  #Create Matrix of sample sizes for Normal and Tightened Sampling standard deviation unknown
  ss<-array(c(10,10,10,10,10,15,20,25,35,50,75,100,150,200,
               7, 7, 7, 7,10,15,20,25,35,50,75,100,150,200,
               7, 7, 7, 7,10,15,20,25,35,50,75,100,150,200,
               7, 7, 7, 7,10,15,20,25,35,50,75,100,150,200,
               5, 5, 5, 7,10,15,20,25,35,50,75,100,150,200,
               5, 5, 5, 7,10,15,20,25,35,50,75,100,150,200,
               4, 4, 5, 7,10,15,20,25,35,50,75,100,150,200,
               4, 4, 5, 7,10,15,20,25,35,50,75,100,150,200,
               3, 4, 5, 7,10,15,20,25,35,50,75,100,150,200,
               3, 4, 5, 7,10,15,20,25,35,50,75,100,150,200,
               3, 4, 5, 7,10,15,20,25,35,50,75,100,150,200,
               3, 4, 5, 7,10,15,20,25,35,50,75,100,150,200),
              dim=c(14,12))
              rownames(ss)<-codes
  #Create Matrix of sample sizes for Reduced Sampling standard deviation unknown
  ssR<-array(c(7, 7, 7, 7, 7, 7, 7,10,15,20,25,30,50,75,
               7, 7, 7, 7, 7, 7, 7,10,15,20,25,30,50,75,
               5, 5, 5, 5, 5, 5, 7,10,15,20,25,30,50,75,
               5, 5, 5, 5, 5, 5, 7,10,15,20,25,30,50,75,
               4, 4, 4, 4, 4, 5, 7,10,15,20,25,30,50,75,
               4, 4, 4, 4, 4, 5, 7,10,15,20,25,30,50,75,
               3, 3, 3, 3, 4, 5, 7,10,15,20,25,30,50,75,
               3, 3, 3, 3, 4, 5, 7,10,15,20,25,30,50,75,
               3, 3, 3, 3, 4, 5, 7,10,15,20,25,30,50,75,
               3, 3, 3, 3, 4, 5, 7,10,15,20,25,30,50,75,
               3, 3, 3, 3, 4, 5, 7,10,15,20,25,30,50,75),
             dim=c(14,11))
             rownames(ssR)<-codes
# AQL for Normal sampling
  aqln<-array(c("0.10","0.15","0.25",
                "0.40","0.65","1.0","1.5","2.5","4.0","6.5","10"),
              dim=c(11,1))
  rownames(aqln)<-c(2:12)
# AQL for Tightened sampling
  aqlt<-array(c("0.10","0.15","0.25",
                "0.40","0.65","1.0","1.5","2.5","4.0","6.5","10"),
              dim=c(11,1))

#get M
  if (type=="Normal")
{M<-ANSIASQZ19M[Codeletter,dAQL+1]/100 }
  else if (type=="Reduced")
  {M<-ANSIASQZ19RM[Codeletter,dAQL]/100}
  else
  {M<-ANSIASQZ19M[Codeletter,dAQL]/100}
  format(M,digits=8)
  options(scipen=999)
# Get Sample size
  if (type=="Normal")
{S<-ss[Codeletter,dAQL+1] }
  else if (type=="Reduced")
  {S<-ssR[Codeletter,dAQL]}
  else
  {S<-ss[Codeletter,dAQL]
  format(M,digits=8)
  options(scipen=999)}
Codeletter
BBM<-qbeta(M,(S-2)/2,(S-2)/2)
k<-(-1)*((BBM/.5)-1)/(sqrt(S)/(S-1))
result<-c(S,k,M)
names(result)<-c("n","k","M")
return(result)
stype="done" }
while(stype=="known") {

  #Create Matrix of M values for Normal and Tightened Sampling standard deviation known  ****
  temp<-array(c(0.114,0.114,0.114,0.114,0.114,0.114,0.161,0.230,0.226,0.217,0.211,0.207,0.193,0.196,
                0.290,0.290,0.290,0.290,0.290,0.290,0.296,0.321,0.330,0.326,0.308,0.296,0.283,0.285,
                0.369,0.369,0.369,0.369,0.369,0.399,0.445,0.478,0.469,0.461,0.438,0.423,0.397,0.402,
                0.310,0.310,0.310,0.310,0.568,0.681,0.721,0.756,0.760,0.721,0.673,0.655,0.615,0.620,
                0.510,0.510,0.510,0.510,0.959,1.090,1.140,1.140,1.140,1.080,1.000,0.980,0.921,0.920,
                1.28,1.28,1.28,1.94,1.88,1.76,1.75,1.80,1.73,1.62,1.51,1.47,1.39,1.39,
                2.73,2.73,2.23,2.76,2.58,2.57,2.62,2.59,2.49,2.35,2.19,2.12,2.00,2.00,
                3.90,3.90,3.00,3.85,3.87,3.77,3.68,3.63,3.43,3.28,3.05,2.99,2.82,2.82,
                6.11,6.11,7.56,6.99,6.05,5.83,5.68,5.60,5.34,4.98,4.68,4.55,4.35,4.34,
                9.27,9.27,10.79,9.97,8.92,8.62,8.43,8.13,7.72,7.34,6.95,6.75,6.48,6.46,
                17.74,17.74,15.60,15.21,13.89,12.88,12.35,12.04,11.57,10.93,10.40,10.17,9.76,9.73,
                24.22,24.22,22.97,20.80,19.46,17.88,17.36,17.05,16.23,15.61,14.87,14.58,14.09,14.02),
              dim=c(14,12))
  ANSIASQZ19M <- temp
  rownames(ANSIASQZ19M)<-codes
  #Create Matrix of M values for Reduced Sampling standard deviation known  **************
  temp<-array(c(.369,.369,.369,.369,.369,.369,.369,.369,.399,.445,.478,.507,.461,.438,
                .310,.310,.310,.310,.310,.310,.310,.568,.681,.721,.756,.791,.721,.673,
                .510,.510,.510,.510,.510,.510,.510,.959,1.09,1.14,1.14,1.18,1.08,1.00,
                1.28,1.28,1.28,1.28,1.28,1.28,1.94,1.88,1.76,1.75,1.80,1.79,1.62,1.51,
                2.73,2.73,2.73,2.73,2.73,2.23,2.76,2.58,2.57,2.62,2.59,2.57,2.35,2.19,
                3.90,3.90,3.90,3.90,3.90,3.00,3.85,3.87,3.77,3.68,3.63,3.61,3.28,3.05,
                6.11,6.11,6.11,6.11,6.11,7.56,6.99,6.05,5.83,5.68,5.60,5.58,4.98,4.68,
                9.27,9.27,9.27,9.27,9.27,10.79,9.97,8.92,8.62,8.43,8.13,8.13,7.34,6.95,
                17.74,17.74,17.74,17.74,17.74,15.60,15.21,13.89,12.88,12.35,12.04,11.88,10.93,10.40,
                24.22,24.22,24.22,24.22,24.22,22.97,20.80,19.46,17.88,17.36,17.05,16.71,15.61,14.87,
                33.67,33.67,33.67,33.67,33.67,31.01,28.64,26.64,24.88,23.96,23.43,23.13,21.77,20.90),
              dim=c(14,11))
  ANSIASQZ19RM<-temp
  rownames(ANSIASQZ19RM)<-codes
  #Create Matrix of sample sizes for Normal and Tightened Sampling standard deviation known  ******
  ss<-array(c(3,3,3,3,3,3,4,6,7,11,15,20,30,40,
              4,4,4,4,4,4,5,6,8,11,16,22,31,42,
              3,3,3,3,3,4,5,6,9,12,17,23,34,45,
              2,2,2,2,3,4,6,7,9,13,19,25,37,49,
              2,2,2,2,3,5,6,8,10,14,21,27,40,54,
              2,2,2,4,4,5,7,8,11,16,23,30,44,59,
              2,2,2,3,4,6,7,9,12,17,25,33,49,65,
              2,2,2,3,4,6,8,10,14,19,28,36,54,71,
              2,2,3,4,5,7,9,11,15,22,32,42,61,81,
              2,2,3,4,5,8,10,13,18,25,36,48,73,93,
              3,3,3,5,6,9,12,15,20,29,42,55,82,109,
              3,3,4,5,7,11,14,17,24,33,49,64,95,127),
            dim=c(14,12))
  rownames(ss)<-codes
  #Create Matrix of sample sizes for Reduced Sampling standard deviation known  ****
  ssR<-array(c(3,3,3,3,3,3,3,3,4,5,6,7,12,17,
               2,2,2,2,2,2,2,3,4,6,7,8,13,19,
               2,2,2,2,2,2,2,3,5,6,8,9,14,21,
               2,2,2,2,2,2,3,4,5,7,8,10,16,23,
               2,2,2,2,2,2,3,4,6,7,9,11,17,25,
               2,2,2,2,2,2,3,4,6,8,10,12,19,28,
               2,2,2,2,2,3,4,5,7,9,11,13,22,32,
               2,2,2,2,2,3,4,5,8,10,13,15,25,36,
               3,3,3,3,3,3,5,6,9,12,15,18,29,42,
               3,3,3,3,3,4,5,7,11,14,17,21,33,49,
               4,4,4,4,4,4,6,8,12,16,20,24,38,56),
             dim=c(14,11))
  rownames(ssR)<-codes
  # AQL for Normal sampling
  aqln<-array(c("0.10","0.15","0.25",
                "0.40","0.65","1.0","1.5","2.5","4.0","6.5","10"),
              dim=c(11,1))
  rownames(aqln)<-c(2:12)
  # AQL for Tightened sampling
  aqlt<-array(c("0.10","0.15","0.25",
                "0.40","0.65","1.0","1.5","2.5","4.0","6.5","10"),
              dim=c(11,1))

  #get M
  if (type=="Normal")
  {M<-ANSIASQZ19M[Codeletter,dAQL+1]/100 }
  else if (type=="Reduced")
  {M<-ANSIASQZ19RM[Codeletter,dAQL]/100}
  else
  {M<-ANSIASQZ19M[Codeletter,dAQL]/100}
  format(M,digits=8)
  options(scipen=999)
  # Get Sample size
  if (type=="Normal")
  {S<-ss[Codeletter,dAQL+1] }
  else if (type=="Reduced")
  {S<-ssR[Codeletter,dAQL]}
  else
  {S<-ss[Codeletter,dAQL]
  format(M,digits=8)
  options(scipen=999)}
  Codeletter
  k<-sqrt((S-1)/S)*qnorm(M,0,1,lower.tail=F)
  result<-c(S,k,M)
  names(result)<-c("n","k","M")
  on.exit(options(op))
  return(result)
stype="done" }
}

