% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getReductionCentroids}
\alias{getReductionCentroids}
\title{Calculate seurat cluster centroids based on a Dimensional reduction}
\usage{
getReductionCentroids(seurat_obj, reduction)
}
\arguments{
\item{seurat_obj}{input seurat object with the dimensional reduction of
choice already present, and seurat clusters computed.}

\item{reduction}{character. The reduction that the centroid calculation
should be based on.}
}
\value{
A list of the length of the number of distinct clusters in the
seurat object metadata, where each element of the list is a numeric vector
of length 2, with the numbers corresponding to the x and y coordinate
respectively of the seurat cluster with the corresponding index.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Utility function to calculate the physical xy coordinates of each seurat
cluster based on a dimensional reduction already present in the object.
The results are returned in a list with the length of the number of distinct
seurat clusters based on the seurat_obj \code{meta.data}.
}
\examples{
data("combined_pbmc")
getReductionCentroids(combined_pbmc, reduction = "umap")

}
