# test_that() is the most basic testing func
# describe() should verify that the right things were implemented

# test data, three cluster lists. c1 and c2 overlap while c3 is far away
c1 <- list(x = c(-1.3, 1.3, -1.48029736616688e-16, -1.97727239868245, 
                 1.97727239868245, 2.22044604925031e-16, 0.728260708834882, -1.24901168984757, 
                 3.44242956206626), 
           y = c(0.632455532033676, 0.632455532033676, 
                -1.26491106406735, -1.56556678313579, -1.56556678313579, 2.5298221281347, 
                -3.12760705106236, -3.4282627701308, -0.204201848011811),
           rad = c(1.3, 1.3, 1, 1, 1, 1, 1, 1, 1),
           centroid = c(0, 0), # originally this was c(4,5) for trans_coord but i fixed it 
           clRad = 4.44242956206626)

c1_shifted_by_4_5 <- list(x = c(2.7, 5.3, 4, 2.02272760131755, 5.97727239868245, 4, 
                                4.72826070883488, 2.75098831015243, 7.44242956206626), y = c(5.63245553203368, 
                                                                                             5.63245553203368, 3.73508893593265, 3.43443321686421, 3.43443321686421, 
                                                                                             7.5298221281347, 1.87239294893764, 1.5717372298692, 4.79579815198819
                                ), rad = c(1.3, 1.3, 1, 1, 1, 1, 1, 1, 1), centroid = c(4, 5), 
                          clRad = 4.44242956206626)

c1_shifted_to_9_0 <- list(x = c(7.7, 10.3, 9, 7.02272760131755, 10.9772723986824, 
                                9, 9.72826070883488, 7.75098831015243, 12.4424295620663), y = c(0.632455532033676, 
                                                                                                0.632455532033676, -1.26491106406735, -1.56556678313579, -1.56556678313579, 
                                                                                                2.5298221281347, -3.12760705106236, -3.4282627701308, -0.204201848011811
                                ), rad = c(1.3, 1.3, 1, 1, 1, 1, 1, 1, 1), centroid = c(9, 0), 
                          clRad = 4.44242956206626)

c2 <- list(x = c(1.01965811965812, 4.91965811965812, 3.06068376068376, 
                 -0.0162220916735012, 6.15406282750692, 3.05811965811966), y = c(4.98850135349066, 
                                                                                 4.98850135349066, 2.02299729301867, 1.64530644625424, 1.82049803637739, 
                                                                                 7.83361550870711), rad = c(2, 1.9, 1.6, 1.5, 1.5, 1.5), centroid = c(3, 
                                                                                                                                                      4), clRad = 4.65406282750692)

c3 <- list(x = c(19.2380952380952, 20.6380952380952, 20.1238095238095, 
                 19.042322998886, 20.1095238095238), y = c(20.3614031611621, 20.3614031611621, 
                                                           19.2771936776758, 19.076228764298, 21.3260856192269), rad = c(0.8, 
                                                                                                                         0.6, 0.6, 0.5, 0.5), centroid = c(20, 20), clRad = 1.23809523809524)

# aggregate them. this has to work
test_cluster_lists <- list(
  c1, c1_shifted_by_4_5, c1_shifted_to_9_0, c2, c3
)

test_centroids <- list(
  "c1" = c(4, 5),
  "c1_shifted_by_4_5" = c(4, 5),
  "c1_shifted_to_9_0" = c(9, 0),
  "c2" = c(3, 4),
  "c3" = c(20, 20)
)

test_radii <- list(
  "c1" = c(), "c1_shifted_by_4_5" = c(),
  "c1_shifted_to_9_0" = c(), "c2" = c(),
  "c3" = c()
)

for (i in 1:length(test_cluster_lists)) {
  test_radii[[i]] <- test_cluster_lists[[i]][[3]]
}

#plot_clusters(test_cluster_lists)
