% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simscen.r
\name{SimScen}
\alias{SimScen}
\title{simscen function
This function takes the mean and covariance of the conditional forecast to draw from the conditional forecast distribution
The shock uncertainty is included in the simulation by default, but can be turned off.}
\usage{
SimScen(
  mu_eps,
  Sigma_eps,
  mu_y,
  Sigma_y,
  big_b,
  big_M,
  n_sim,
  h,
  varbls,
  idx_sampled = 1:dim(mu_eps)[3],
  shock_uncertainty = TRUE
)
}
\arguments{
\item{mu_eps}{mean innovation}

\item{Sigma_eps}{variance innovation}

\item{mu_y}{mean forecast}

\item{Sigma_y}{variance forecast}

\item{big_b}{history forecast}

\item{big_M}{IRF (innovation loading)}

\item{n_sim}{number of simulations}

\item{h}{horizon}

\item{varbls}{variable names}

\item{idx_sampled}{index of random sample to use instead of full draws (from scenarios)}

\item{shock_uncertainty}{(logical; optional) whether to include uncertainty in shocks (default is TRUE)}
}
\value{
conditional forecast path and distribution
}
\description{
simscen function
This function takes the mean and covariance of the conditional forecast to draw from the conditional forecast distribution
The shock uncertainty is included in the simulation by default, but can be turned off.
}
\examples{
\dontrun{
# Example usage after scenarios() function call
# Requires scenario results from scenarios() function
result <- SimScen(mu_eps = scenario_output$mu_eps, 
                  Sigma_eps = scenario_output$Sigma_eps,
                  mu_y = scenario_output$mu_y, 
                  Sigma_y = scenario_output$Sigma_y,
                  big_b = scenario_output$big_b, 
                  big_M = scenario_output$big_M,
                  n_sim = 1000, h = 3, varbls = c("GDP", "CPI", "FFR"))
}

}
