% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_modelSummary.R
\name{extract_summary_linearEffects}
\alias{extract_summary_linearEffects}
\title{Internal helper to extract summary of linear effects in a gam model}
\usage{
extract_summary_linearEffects(model, method_expTransform = "simple")
}
\arguments{
\item{model}{Model fitted with \code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}.}

\item{method_expTransform}{One of \code{c("simple","delta")}, stating if
standard errors and confidence interval limits should be transformed by
a simple exp transformation or using the delta method. The delta method can
be unstable in situations and lead to negative confidence interval limits.
Only used when the model was estimated with a log or logit link.}
}
\description{
Internal helper function to create a \code{data.frame} containing the linear
effects summary of a model fitted with \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.
}
\details{
If the model was estimated with a log or logit link, the function
automatically performs an exponential transformation of the effect,
see argument \code{method_expTransform}.
}
