% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.double.grp.single.R
\name{perm.double.grp.single}
\alias{perm.double.grp.single}
\title{Double permutation approach for gambit of the group}
\usage{
perm.double.grp.single(
  obs,
  scan,
  ctrlf,
  nperm,
  progress = TRUE,
  index = "sri",
  measure,
  test = "median",
  df = NULL,
  dfid = NULL,
  ...
)
}
\arguments{
\item{obs}{a data frame of gambit of the group observations. The data frame must have a column named 'ID'.}

\item{scan}{an integer indicating the column of scans of individual associations in obs.}

\item{ctrlf}{A confounding factor by which to control group associationsin obs.}

\item{nperm}{number of permutations to perform.}

\item{progress}{a boolean indicating if the permutation process must be visible.}

\item{index}{Which type of index of associations to calculate:
\itemize{
\item 'sri' for Simple ratio index: \eqn{x \div x+yAB+yA+yB}
\item 'hw' for Half-weight index: \eqn{x/x+yAB+1/2(yA+yB)}
\item 'sr' for Square root index:\eqn{x/sqr((x+yAB+yA)(x+yAB+yB))}
}}

\item{measure}{a character indicating the social network measure to compute (Only those available in ANTs)}

\item{test}{a character indicating the test to realize to account for the social network measure}

\item{df}{a data frame of individual characteristics in which store permutations.}

\item{dfid}{an integer or a string indicating the column with individual ids in argument \emph{df}.}

\item{...}{Additional arguments related to the social network measure to compute (argument measure).}
}
\value{
A numeric vector of individuals social measure corrected by double permutation approch (node label permutation can the be perfomed on this output)
}
\description{
Double permutation approach for gambit of the group
}
\details{
Output need to be incorporated in a data frame and node label permutations with ANTs function perm.net.nl need to be performed before using any ANTs functions "stat.".
}
\references{
Farine, D. R., & Carter, G. G. (2022). Permutation tests for hypothesis testing with animal social network data: Problems and potential solutions. Methods in Ecology and Evolution, 13, 144- 156. https://doi.org/10.1111/2041-210X.13741
}
