% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theil.kendall.R
\name{theil.kendall}
\alias{theil.kendall}
\title{Calculate Theil-Kendall beta}
\usage{
theil.kendall(
  y,
  x,
  H0 = NULL,
  do.abbreviated = FALSE,
  do.alpha = FALSE,
  alternative = c("two.sided", "less", "greater"),
  CI.width = 0.95,
  max.exact.cases = 10,
  nsims.mc = 1e+05,
  seed = NULL,
  do.asymp = FALSE,
  do.exact = TRUE,
  do.CI = FALSE,
  do.mc = FALSE
)
}
\arguments{
\item{y}{Numeric vector of same length as x}

\item{x}{Numeric vector of same length as y}

\item{H0}{Null hypothesis value (defaults to \code{NULL})}

\item{do.abbreviated}{Boolean indicating whether or not to use abbreviated Theil procedure (defaults to \code{FALSE})}

\item{do.alpha}{Boolean indicating whether or not to report estimate of alpha (defaults to \code{FALSE})}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{CI.width}{Confidence interval width (defaults to \code{0.95})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{10})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{100000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}

\item{do.CI}{Boolean indicating whether or not to perform confidence interval calculations (defaults to \code{FALSE})}

\item{do.mc}{Boolean indicating whether or not to perform Monte Carlo calculations (defaults to \code{FALSE})}
}
\value{
An ANSMstat object with the results from applying the function
}
\description{
\code{theil.kendall()} calculates the Theil-Kendall beta and is used in chapter 11 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 11.6 from "Applied Nonparametric Statistical Methods" (5th edition)
theil.kendall(ch11$reportedtime, ch11$parentlimit, do.alpha = TRUE)

# Exercise 11.10 from "Applied Nonparametric Statistical Methods" (5th edition)
theil.kendall(ch11$N.Scotland, ch11$SW.England)

}
