% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.scores.test.R
\name{normal.scores.test}
\alias{normal.scores.test}
\title{Perform Normal Scores test}
\usage{
normal.scores.test(
  x,
  y,
  H0 = NULL,
  alternative = c("two.sided", "less", "greater"),
  max.exact.cases = 25,
  do.asymp = FALSE,
  do.exact = TRUE
)
}
\arguments{
\item{x}{Numeric vector}

\item{y}{Numeric vector}

\item{H0}{Null hypothesis value (defaults to \code{NULL})}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{25})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{normal.scores.test()} performs the Normal Scores test and is used in chapters 6 and 8 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 5.8 from "Applied Nonparametric Statistical Methods" (5th edition)
normal.scores.test(ch6$groupA, ch6$groupB, do.exact = FALSE, do.asymp = TRUE)

# Exercise 6.15 from "Applied Nonparametric Statistical Methods" (5th edition)
normal.scores.test(ch6$doseI, ch6$doseII)

}
