% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atc_property.R
\name{atc_property}
\alias{atc_property}
\alias{atc_official}
\alias{atc_name}
\alias{atc_trivial_nl}
\alias{atc_certe}
\alias{atc_umcg}
\alias{atc_tradenames}
\title{Property of an antibiotic}
\usage{
atc_property(x, property = "official")

atc_official(x, language = NULL)

atc_name(x, language = NULL)

atc_trivial_nl(x)

atc_certe(x)

atc_umcg(x)

atc_tradenames(x)
}
\arguments{
\item{x}{a (vector of a) valid \code{\link{atc}} code or any text that can be coerced to a valid atc with \code{\link{as.atc}}}

\item{property}{one of the column names of one of the \code{\link{antibiotics}} data set, like \code{"atc"} and \code{"official"}}

\item{language}{language of the returned text, defaults to English (\code{"en"}) and can be set with \code{\link{getOption}("AMR_locale")}. Either one of \code{"en"} (English) or \code{"nl"} (Dutch).}
}
\value{
A vector of values. In case of \code{atc_tradenames}, if \code{x} is of length one, a vector will be returned. Otherwise a \code{\link{list}}, with \code{x} as names.
}
\description{
Use these functions to return a specific property of an antibiotic from the \code{\link{antibiotics}} data set, based on their ATC code. Get such a code with \code{\link{as.atc}}.
}
\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a comprehensive tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
as.atc("amcl")         # J01CR02
atc_name("amcl")        # Amoxicillin and beta-lactamase inhibitor
atc_name("amcl", "nl")  # Amoxicilline met enzymremmer
atc_trivial_nl("amcl")  # Amoxicilline/clavulaanzuur
atc_certe("amcl")       # amcl
atc_umcg("amcl")        # AMCL
}
\seealso{
\code{\link{antibiotics}}
}
