% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stock_class.R
\name{Stock}
\alias{Stock}
\title{R6 Class representing a stock}
\description{
A stock object has life history parameters, fields and methods for a biomass dynamic model.
}
\details{
A stock has biomass, effort, catch and hcr_ip and hcr_op fields as well as the life history parameters.
The population dynamics are a simple biomass dynamic model.
The Stock class is used for the Shiny apps in the AMPLE package.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{biomass}}{Array of biomass}

\item{\code{catch}}{Array of catches}

\item{\code{effort}}{Array of fishing effort}

\item{\code{hcr_ip}}{Array of HCR input signals}

\item{\code{hcr_op}}{Array of HCR output signals}

\item{\code{msy}}{MSY (default = 100).}

\item{\code{r}}{Growth rate (default = 0.6). Set by the user in the app.}

\item{\code{k}}{Carrying capacity (default = NULL - set by msy and r when object is initialised).}

\item{\code{p}}{Shape of the production curve (default = 1).}

\item{\code{q}}{Catchability (default = 1).}

\item{\code{lrp}}{Limit reference point, expressed as depletion (default = 0.2).}

\item{\code{trp}}{Target reference point, expressed as depletion (default = 0.5).}

\item{\code{b0}}{Virgin biomass (default = NULL - set by msy and r when object is initialised).}

\item{\code{current_corrnoise}}{Stores the current values of the correlated noise (by iteration).}

\item{\code{biol_sigma}}{Standard deviation of biological variability (default = 0).}

\item{\code{last_historical_timestep}}{The last historical timestep of catch and effort data.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Stock$new()}}
\item \href{#method-reset}{\code{Stock$reset()}}
\item \href{#method-reactive}{\code{Stock$reactive()}}
\item \href{#method-fill_history}{\code{Stock$fill_history()}}
\item \href{#method-fill_catch_history}{\code{Stock$fill_catch_history()}}
\item \href{#method-fill_biomass}{\code{Stock$fill_biomass()}}
\item \href{#method-as_data_frame}{\code{Stock$as_data_frame()}}
\item \href{#method-project}{\code{Stock$project()}}
\item \href{#method-relative_cpue}{\code{Stock$relative_cpue()}}
\item \href{#method-relative_effort}{\code{Stock$relative_effort()}}
\item \href{#method-replicate_table}{\code{Stock$replicate_table()}}
\item \href{#method-time_periods}{\code{Stock$time_periods()}}
\item \href{#method-performance_indicators}{\code{Stock$performance_indicators()}}
\item \href{#method-pi_table}{\code{Stock$pi_table()}}
\item \href{#method-clone}{\code{Stock$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new stock object, with fields of the right dimension and NA values (by calling the \code{reset()} method.
See the \code{reset()} method for more details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$new(stock_params, mp_params, niters = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{stock_params}}{A list of stock parameters with essential elements: r (growth rate, numeric), stock_history (string: "fully", "over", "under") initial_year (integer), last_historical_timestep (integer), nyears (integer), biol_sigma (numeric).}

\item{\code{mp_params}}{A list of the MP parameters. Used to fill HCR ip and op.}

\item{\code{niters}}{The number of iters in the stock (default = 1).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new Stock object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\if{latex}{\out{\hypertarget{method-reset}{}}}
\subsection{Method \code{reset()}}{
Resets an existing stock object, by remaking all fields (possibly with different dimensions for the array fields) .
Fills up the catch, effort and biomass fields in the historical period based on the stock history and
life history parameters in the \code{stock_params} argument.
This is a reactive method which invalidates a reactive instance of this class after it is called.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$reset(stock_params, mp_params, niters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{stock_params}}{A list with essential elements: r (growth rate, numeric, default=6), stock_history (string: "fully", "over", "under", default="fully") initial_year (integer, default=2000), last_historical_timestep (integer, default=10), nyears (integer, default=30), biol_sigma (numeric, default = 0).}

\item{\code{mp_params}}{A list of the MP parameters. Used to fill HCR ip and op.}

\item{\code{niters}}{The number of iters in the stock (default = 1).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new Stock object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reactive"></a>}}
\if{latex}{\out{\hypertarget{method-reactive}{}}}
\subsection{Method \code{reactive()}}{
Method to create a reactive instance of a Stock.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$reactive()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a reactiveExpr.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fill_history"></a>}}
\if{latex}{\out{\hypertarget{method-fill_history}{}}}
\subsection{Method \code{fill_history()}}{
Fills the historical period of the stock
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$fill_history(stock_params, mp_params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{stock_params}}{Named list with last_historical_timestep and stock_history elements.}

\item{\code{mp_params}}{A list of the MP parameters. Used to fill HCR ip and op.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fill_catch_history"></a>}}
\if{latex}{\out{\hypertarget{method-fill_catch_history}{}}}
\subsection{Method \code{fill_catch_history()}}{
Fill up the historical period of catches with random values to simulate a catch history
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$fill_catch_history(stock_params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{stock_params}}{A list with essential elements: r (growth rate, numeric), stock_history (string: "fully", "over", "under") initial_year (integer), last_historical_timestep (integer), nyears (integer).}

\item{\code{stock_history}}{Character string of the exploitation history (default = "fully", alternatives are "under" or "over").}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fill_biomass"></a>}}
\if{latex}{\out{\hypertarget{method-fill_biomass}{}}}
\subsection{Method \code{fill_biomass()}}{
Fills the biomass in the next timestep based on current biomass and catches
The surplus production model has the general form:
\code{Bt+1 = Bt + f(Bt) - Ct}
Where the production function f() is a Pella & Tomlinson model with shape
\code{f(Bt) = r/p Bt * (1 - (Bt/k)^p)}
Here p is fixed at 1 to give a Schaefer model
\code{cpue = Ct / Et = qBt}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$fill_biomass(ts, iters = 1:dim(self$biomass)[1])}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ts}}{The biomass time step to be filled (required catch etc in ts - 1).}

\item{\code{iters}}{The iterations to calculate the biomass for (optional - default is all of them).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-as_data_frame"></a>}}
\if{latex}{\out{\hypertarget{method-as_data_frame}{}}}
\subsection{Method \code{as_data_frame()}}{
Produces a data.frame of some of the array-based fields, like biomass.
Just used for testing purposes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$as_data_frame()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-project"></a>}}
\if{latex}{\out{\hypertarget{method-project}{}}}
\subsection{Method \code{project()}}{
Projects the stock over the time steps given and updates the biomass, HCR ip / op and catches
It uses a simple biomass dynamic model where the catches or fishing effort are set every time step by the harvest control rule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$project(timesteps, mp_params, iters = 1:dim(self$biomass)[1])}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timesteps}}{The timesteps to project over. A vector of length 2 (start and end).}

\item{\code{mp_params}}{A vector of management procedure parameters.}

\item{\code{iters}}{A vector of iterations to be projected. Default is all the iterations in the stock}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A stock object (a reactiveValues object with bits for the stock)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-relative_cpue"></a>}}
\if{latex}{\out{\hypertarget{method-relative_cpue}{}}}
\subsection{Method \code{relative_cpue()}}{
The catch per unit effort (CPUE, or catch rate) relative to the CPUE in the last historical period.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$relative_cpue()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An array of same dims as the catch and effort fields.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-relative_effort"></a>}}
\if{latex}{\out{\hypertarget{method-relative_effort}{}}}
\subsection{Method \code{relative_effort()}}{
The effort relative to the effort in the last historical period.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$relative_effort()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An array of same dims as the effort field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-replicate_table"></a>}}
\if{latex}{\out{\hypertarget{method-replicate_table}{}}}
\subsection{Method \code{replicate_table()}}{
Summarises the final year of each iteration. Only used for the Measuring Performance app.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$replicate_table(iters = 1, quantiles = c(0.05, 0.95))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{The iterations to calculate the table values for (default is iteration 1).}

\item{\code{quantiles}}{Numeric vector of the quantile range. Default values are 0.05 and 0.95.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-time_periods"></a>}}
\if{latex}{\out{\hypertarget{method-time_periods}{}}}
\subsection{Method \code{time_periods()}}{
Calculates the short, medium and long term periods to calculate the performance indicators over,
based on the last historic year of data and the number of years in the projection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$time_periods()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-performance_indicators"></a>}}
\if{latex}{\out{\hypertarget{method-performance_indicators}{}}}
\subsection{Method \code{performance_indicators()}}{
Gets the performance indicators across all indicators, for three time periods.
Used in the Measuring Performance and Comparing Performance apps.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$performance_indicators(
  iters = 1:dim(self$biomass)[1],
  quantiles = c(0.05, 0.95)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{The iterations to calculate the table values for (default is all of them).}

\item{\code{quantiles}}{Numeric vector of the quantile range. Default values are 0.05 and 0.95.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data.frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pi_table"></a>}}
\if{latex}{\out{\hypertarget{method-pi_table}{}}}
\subsection{Method \code{pi_table()}}{
Makes a table of the performance indicators.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$pi_table(iters = 1:dim(self$biomass)[1], quantiles = c(0.05, 0.95))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{The iterations to calculate the table values for (default is all of them).}

\item{\code{quantiles}}{Numeric vector, length 2, of the low and high quantiles.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stock$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
