% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcs.R
\name{current_pi_table}
\alias{current_pi_table}
\alias{get_projection_pis}
\alias{get_summaries}
\title{Routines for calculating and displaying various performance indicators.}
\usage{
current_pi_table(dat, pichoice = c("pi1", "sbsbf0", "catch"))

get_projection_pis(stock, stock_params, app_params, current_timestep)

get_summaries(stock, stock_params, app_params, quantiles)
}
\arguments{
\item{dat}{A data.frame with the 20th, 80th and 50th percentile value of each indicator.}

\item{pichoice}{A character vector of the indicator names to be included in the table}

\item{stock}{A list with elements biomass, hcr_ip, hcr_op, effort and catch.}

\item{stock_params}{A vector of life history and stochasticy parameters.}

\item{app_params}{A vector of application parameters.}

\item{current_timestep}{The current timestep.}

\item{quantiles}{The quantiles to calculate the indicators over.}
}
\value{
Various data.frames with summaries in different formats.
}
\description{
current_pi_table() takes the processed indicators and formats them into a table.

get_projection_pis() get the performance indicators for the Introduction to Projections AMPED app

get_summaries() gets the current indicators including SB/SBF=0, catch and the probability of being above the limit reference point.
}
\examples{
# Set up all the bits for a projection - should be done inside a Shiny app
# Managment procedure bits - should come from Shiny app inputs
input_mp <- list(
  blim_belbow = c(0.2, 0.5),
  cmin_cmax = c(10, 140), 
  constant_catch_level = 50,
  constant_effort_level = 1,
  emin_emax = c(0.1, 0.5),
  hcr_type = "threshold_catch")
mp_params <- mp_params_switcheroo(input_mp)

# Stochasticity bits - should come from Shiny app inputs
input_stoch <- list(
  biol_est_bias = 0,
  biol_est_sigma = 0,
  biol_prod_sigma = 0, 
  show_var <- TRUE)
stoch_params <- set_stoch_params(input_stoch)

# Life history bits - should come from Shiny app inputs
input_lh <- list(
  stock_history = "fully",
  stock_lh = "medium")
lh_params <- get_lh_params(input_lh)

# Stitch together and make other parameters - should be inside an Shiny app 
stock_params <- c(stoch_params, lh_params)
app_params <- list(initial_year = 2009, last_historical_timestep = 10)

# Make the null stock and fill it up
# In a Shiny app use the create_stock() function but cannot do here so make an equivalent stock
stock <- list(biomass = NULL, hcr_ip = NULL, hcr_op = NULL, effort = NULL, catch = NULL)
stock <- reset_stock(stock = stock, stock_params = stock_params, mp_params = mp_params,
  app_params = app_params, initial_biomass = stock_params$b0, nyears = 20, niters = 10)
# Finally project over the timesteps
out <- project(stock, timesteps = c(11,20), stock_params = stock_params, mp_params = mp_params,
  app_params = app_params)
# Get the summaries
pisums <- get_summaries(stock=out, stock_params=stock_params, app_params=app_params,
  quantiles=c(0.01,0.05,0.20,0.5,0.80,0.95,0.99))
# Get the current PI table in a neat format from one of the summary tables
current_pi_table(dat=pisums$periodqs, pichoice=c("pi1", "sbsbf0", "catch"))

# Get the PIs for the Introduction to Projections app
get_projection_pis(stock=out, stock_params=stock_params, app_params=app_params, current_timestep=15)
}
