% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/Getters.R
\docType{methods}
\name{getVoxelSize}
\alias{getVoxelSize}
\alias{getVoxelSize,VoxelSpace-method}
\title{Gets the elemental size of a voxel (dx, dy, dz) in meter.}
\usage{
getVoxelSize(vxsp)

\S4method{getVoxelSize}{VoxelSpace}(vxsp)
}
\arguments{
\item{vxsp}{the \code{\link{VoxelSpace-class}} object.}
}
\value{
the size of the voxel in meter, as a numerical vector.
}
\description{
Gets the elemental size of a voxel (dx, dy, dz) in meter.
}
\examples{
# load a voxel file
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))
# retrieve voxel size
getVoxelSize(vxsp)
}
