% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_partial_name.R
\name{search_partial_name}
\alias{search_partial_name}
\title{Partial-name search}
\usage{
search_partial_name(taxon, geo_only = FALSE, output_format = "simple",
  index_type, limit)
}
\arguments{
\item{taxon}{string: part of the scientific, common name of the taxa}

\item{geo_only}{logical: if TRUE, only results that have geospatial occurrence records will be included}

\item{output_format}{string: controls the print method for the returned object. Either "complete" (the complete data structure is displayed), or "simple" (a simplified version is displayed). Note that the complete data structure exists in both cases: this option only controls what is displayed when the object is printed to the console. The default output format is "simple"}

\item{index_type}{string: the index type to limit. Values include: TAXON REGION COLLECTION INSTITUTION DATASET. By default, no index_type limit is applied}

\item{limit}{numeric: the maximum number of matches returned (defaults to the server-side value - currently 10)}
}
\value{
A dataframe of results. The contents (column names) of the data frame will vary depending on the details of the search and the results.
}
\description{
A partial-name search for species names & identifiers used at the ALA. If searching for a taxon name, and the scientific name or common name of the taxon are known, use \code{\link{search_names}} instead.
}
\examples{
\dontrun{
# find any names containing "allaba"
search_partial_name("allaba",output_format="simple")

# retrieve only species that have geolocated occurrence records
search_partial_name("Gallaba",geo_only=TRUE)
}
}
\references{
Associated ALA web service: \url{http://api.ala.org.au/#ws25}
}
\seealso{
\code{\link{search_names}} for searching known scientific or common taxonomic names
}
