% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aniso_simulation.R
\name{aniso_simulation}
\alias{aniso_simulation}
\title{Simulate anisotropic 2D particle movement}
\usage{
aniso_simulation(
  sz = c(200, 200),
  len_t = 200,
  M = 50,
  model_name = "BM",
  noise = "gaussian",
  I0 = 20,
  Imax = 255,
  pos0 = matrix(NaN, nrow = M, ncol = 2),
  rho = c(0.95, 0.9),
  H = c(0.4, 0.3),
  sigma_p = 2,
  sigma_bm = c(1, 0.5),
  sigma_ou = c(2, 1.5),
  sigma_fbm = c(2, 1.5)
)
}
\arguments{
\item{sz}{frame size of simulated image with default \code{c(200,200)}.}

\item{len_t}{number of time steps with default 200.}

\item{M}{number of particles with default 50.}

\item{model_name}{stochastic process simulated, options from
('BM','OU','FBM','OU+FBM'), with default 'BM'.}

\item{noise}{background noise, options from ('uniform','gaussian'),
with default 'gaussian'.}

\item{I0}{background intensity, value between 0 and 255, with default 20.}

\item{Imax}{maximum intensity at the center of the particle, value between 0
and 255, with default 255.}

\item{pos0}{initial position for M particles, matrix with dimension M by 2.}

\item{rho}{correlation between successive step and previous step in O-U
process, in x, y-directions. A vector of length 2 with values between 0 and 1,
default \code{c(0.95,0.9)}.}

\item{H}{Hurst parameter of fractional Brownian Motion, in x, y-directions.
A vector of length 2, value between 0 and 1, default \code{c(0.4,0.3)}.}

\item{sigma_p}{radius of the spherical particle (3sigma_p), with default 2.}

\item{sigma_bm}{distance moved per time step of Brownian Motion,
in x,y-directions. A vector of length 2 with default \code{c(1,0.5)}.}

\item{sigma_ou}{distance moved per time step of Ornstein–Uhlenbeck process,
in x, y-directions. A vector of length 2 with default \code{c(2,1.5)}.}

\item{sigma_fbm}{distance moved per time step of fractional Brownian Motion,
in x, y-directions. A vector of length 2 with default \code{c(2,1.5)}.}
}
\value{
Returns an S4 object of class \code{anisotropic_simulation}.
}
\description{
Simulate anisotropic 2D particle movement from a user selected stochastic
process, and output intensity profiles.
}
\examples{
library(AIUQ)
# -------------------------------------------------
# Example 1: Simple diffusion for 200 images with
#            200 by 200 pixels and 50 particles
# -------------------------------------------------
aniso_sim_bm = aniso_simulation()
show(aniso_sim_bm)

# -------------------------------------------------
# Example 2: Simple diffusion for 100 images with
#            100 by 100 pixels and slower speed
# -------------------------------------------------
aniso_sim_bm = aniso_simulation(sz=100,len_t=100,sigma_bm=c(0.5,0.1))
show(aniso_sim_bm)

# -------------------------------------------------
# Example 3: Ornstein-Uhlenbeck process
# -------------------------------------------------
aniso_sim_ou = aniso_simulation(model_name="OU")
show(aniso_sim_ou)
}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.

Cerbino, R., & Trappe, V. (2008). Differential dynamic microscopy: probing
wave vector dependent dynamics with a microscope. Physical review letters,
100(18), 188102.
}
\author{
\packageAuthor{AIUQ}
}
