\name{ab.areal.interp}
\alias{ab.areal.interp}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Area-based areal interpolation for multiple polygons}
\description{Given a list of target polygons, a list of zonal polygons, and a matrix of data associated with the zonal polygons, interpolate zonal polygon data to specified target polygons.  As a wrapper of \code{mult.arealw} and \code{dp.interp}, it generates areal weights as an intermediate product, which can also be returned if desired. This allows other variables in the data record to be interpolated to the same polygons without having to redo the costly weight-calculating step.
}
\usage{
ab.areal.interp(target.ind = "all", targetlist = firepgpc, trim = TRUE, 
  recvar = 1, recvals = bgvals, zones = cabggpc, zbbmat = cabgbbmat, 
  zoneareas = rbgarea, appdam = TRUE, dr = damrats, twokcensus = TRUE, 
  digits = 6, nobounds = FALSE, keepwts = TRUE, verbose = 2)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{target.ind}{A vector containing list indices of target polygons, or character \dQuote{all}, which indicates the entire list is to be used.}
  \item{targetlist}{A list of possible target polygons}
  \item{trim}{A logical indicating whether areal weights should be stored compactly or in one long vector per target polygon.  The default is \code{TRUE}, as for lengthy lists of target polygons available memory can become prohibitive.}
  \item{recvar}{An integer indicating which column of the record value matrix to use. That is, what variable is to be interpolated.}
  \item{recvals}{A matrix of record values containing the data to be interpolated, with rows corresponding to zones, and columns corresponding to different variables.}
  \item{zones}{List of zonal polygons from which data will be interpolated to the target.}
  \item{zbbmat}{\dQuote{Zonal bounding box matrix.} Either a matrix of dimension \code{length(zones)} by 4, or character \dQuote{none}.  If \dQuote{none,} an appropriate matrix is automatically computed by a call to \code{bbox.mat}.  See \sQuote{Details.}}
  \item{zoneareas}{A vector giving the area of each zone or character \dQuote{none}, indicating they must be calculated inside the function.}
  \item{appdam}{CA Wildfire specific.  A logical indicating whether or not to apply the empirically derived damage ratio.}
   \item{dr}{CA Wildfire specific.  A vector giving precalculated damage ratios by block group.  Only used if \code{appdam=TRUE.}}
  \item{twokcensus}{Logical indicating whether the data in question is block group level data for California from the 2000 US Census. If \sQuote{TRUE}, the function automatically handles certain ideosyncracies associated with that data.}
  \item{digits}{Digits argument passed to \code{round} internally.  Used in setting the tolerance for considering fractional overlap to be 100 percent.  Due to numerical issues, overlap will not always be identically 1 when a zone is contained entirely within the target.  There should be little reason to modify this away from the default value of six.}
  \item{nobounds}{Logical indicating whether or not to return the estimates without bounds. Default is \sQuote{FALSE}, but there may be situations where having no bounds will be more convenient for handling data objects.  See \code{Details} for how the bounds are generated.}
  \item{keepwts}{Whether or not to also return the areal weights calculated by \code{arealw}.  See \code{Value} for details.}
  \item{verbose}{An integer indicating how frequently to print progress through the target polygons.  Will print a message every time 10 to the \code{verbose} power polygons have been processed.   Setting verbose negative results in no progress output.}
}

\details{
If not \dQuote{none}, \sQuote{zbbmat} must take the form of a \code{length(zones)} by 4 matrix, where each row corresponds to the bounding latitude and longitude values for polygons in \code{zones}, the same format returned by the function \code{\link{bbox.mat}}.  The columns correspond to low longitude, high longitude, low latitude and high latitude respectively.

The lower bound estimates are generated by assuming any zone less than fully enclosed by the current target polygon contributes zero to the total value contained.  The upper bound is generated by  assuming that any zone with nonzero overlap contributes its entire value.  In all cases, zones that are entirely enclosed contribute their entire value.  
}
\value{
The output under default settings is a list of two elements.  The first element is a \code{length(target.ind)} by 3 matrix giving the expected value, lower bound and upper bound on enclosed value, for each target polygon specified.  The second element is another list, each entry of which has the matrix of areal weights for the corresponding target polygon.  In these matrices, the first column indexes those zones with nonzero overlap, and the second column gives those overlaps. These matrices can be passed to \code{dp.interp} to generate other interpolated values for the same target polygon, either individually, or using \code{lapply}.   

If \code{nobounds}=\code{TRUE}, lower and upper bound are not returned, and the result is just a vector of length one.  

If \code{keepwts}=\code{FALSE}, the function returns only the matrix or vector as above, and the areal weights are not returned.

If \code{trimout}=\code{FALSE}, the weights are returned as a vector of length equal to \code{nrow(recvals)}, rather than as a matrix containing specifying only those nonzero weights.  See help for \code{arealw} for more info.   

Thus, there can be six different possible output forms.  The default should suffice in most cases.  
}
%\references{ ~put references to the literature/web site here ~ }
\author{Benjamin P. Bryant, \email{bryant@prgs.edu}}

\note{The bounds on the outputs when \code{appdam} is set to \code{TRUE} do not take into account uncertainty in the damage ratio.  The absolute high would be to take the upper bound when not applying the damage ratio, and the absolute low is always zero.}  

\examples{


data(bgvals)
data(cabgbbmat)
data(cabggpc)
data(damrats)
data(fpdemogpc)
data(rbgarea)
data(polytobg)

#Calculate structures enclosed by the Union and Cedar fires:
cedar <- ab.areal.interp(target.ind=c(1,3),targetlist=fpdemogpc,recvar=1,
  appdam=FALSE,keepwts=TRUE)
  
#check it out:
cedar[[1]]

#Using the weights already generated, calculate the total value enclosed for
#the Cedar fire:
dp.interp(cedar[[2]][[2]],recvar=2,appdam=FALSE,trimmedin=TRUE)

#Again using the weights already generated, calculate estimated houses
#destroyed, this time for both at the same time:
lapply(cedar[[2]],dp.interp,recvar=1,appdam=TRUE,trimmedin=TRUE)

}
\keyword{spatial}% at least one, from doc/KEYWORDS
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
