% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ahr.R
\name{ahrAJ}
\alias{ahrAJ}
\title{ahrAJ}
\usage{
ahrAJ(L, target, states, transitions, censoring, data, null.theta = NULL,
  contrast = NULL, multi.test = FALSE, cov = FALSE, bootstrap = 0)
}
\arguments{
\item{L}{time-limit specifying time-interval [0,L] over which average hazard ratios will be calculated}

\item{target}{string specifying the target transition, for which the Aalen-Johansen estimator is to be calculated}

\item{states}{list of state names}

\item{transitions}{matrix of possible transitions}

\item{censoring}{name of censoring 'state'}

\item{data}{data frame containing variables id, time, from, to (see \code{\link{etm}}) and Trt (factor giving treatment groups)}

\item{null.theta}{vector specifying the null hypothesis for the average hazard ratios}

\item{contrast}{vector of contrasts to test H_0: contrast * (theta - null.theta) = 0}

\item{multi.test}{calculate multivariate test statistic if TRUE}

\item{cov}{if TRUE calculate covariance matrix estimator (direct)}

\item{bootstrap}{number of bootstrap samples to draw for variance estimation (default: 0 = no bootstrap, direct variance estimation). This parameter is ignored if cov=TRUE}
}
\value{
An object of class '"ahr"'
}
\description{
Estimate average hazard ratios from k independent samples based on the Aalen-Johansen estimator of the empirical transition probabilities (NOTE: variance estimation not yet implemented)
}
\examples{
## competing risks
Trt <- factor(rep(c(0,1), c(100, 100)))
T <- c(rexp(100, 1), rexp(100, 2))
C <- c(rexp(100, 1), rexp(100, 2))
r <- c(rbinom(100, 2, 0.5), rbinom(100, 2, 0.4))
r[(r == 0) | (T > C)] <- "cens"
data <- data.frame(id=1:200, time=pmin(T,C), from=rep(0, 200), to=r, Trt=Trt)
tra <- matrix(FALSE, nrow=3, ncol=3)
tra[1, 2:3] <- TRUE
# estimate average subdistribution hazard ratio up to L=2 for event type 1
fit <- ahrAJ(2, target="0 1", states=c("0", "1", "2"), transitions=tra, censoring="cens",
             data=data, cov=TRUE)
fit
}
\references{
J.~D. Kalbfleisch and R.~L. Prentice. Estimation of the average hazard ratio. \emph{Biometrika}, 68(1):105--112, Apr. 1981.
}
\seealso{
\code{\link{aj}}
}

