% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMNetworksAnalyser.R
\docType{methods}
\name{getNetworkParameters}
\alias{getNetworkParameters}
\alias{getNetworkParameters,AFMImageNetworksAnalysis-method}
\alias{getNetworkParameters,AFMImage-method}
\title{Get Network parameters}
\usage{
getNetworkParameters(AFMImageNetworksAnalysis, AFMImage)


  \S4method{getNetworkParameters}{AFMImageNetworksAnalysis}(AFMImageNetworksAnalysis,
  AFMImage)
}
\arguments{
\item{AFMImageNetworksAnalysis}{an \code{\link{AFMImageNetworksAnalysis}}}

\item{AFMImage}{an \code{\link{AFMImage}}}
}
\value{
a data.table of network parameters: 
\itemize{
  \item totalNumberOfNodes the total number of nodes with degree different of 2
  \item totalNumberOfNodesWithDegreeTwoOrMore  the total number of nodes with degree 2 or more
  \item totalNumberOfNodesWithDegreeOne the total number of nodes with degree one
  \item numberOfNodesPerArea  the total number of nodes with degree diffrent of 2 per area
  \item numberOfNodesPerSurfaceArea the total number of nodes with degree diffrent of 2 per surface area
  \item MeanPhysicalDistanceBetweenNodes the mean physical distance between nodes of degree different of two
}
}
\description{
Get basic network parameters :
Total root mean square Roughness or Total Rrms or totalRMSRoughness_TotalRrms\cr
Mean roughness or Ra or MeanRoughness_Ra
}
\details{
\code{getNetworkParameters} returns a data.table of network parameters
}
\examples{
\dontrun{
library(AFM)
library(parallel)

data(AFMImageCollagenNetwork)
AFMImage<-AFMImageCollagenNetwork
AFMIA = new("AFMImageNetworksAnalysis")
AFMIA@heightNetworksslider=10
AFMIA@filterNetworkssliderMin=150
AFMIA@filterNetworkssliderMax=300
AFMIA@smallBranchesTreatment=TRUE
clExist<-TRUE
cl <- makeCluster(2,outfile="")
AFMIA<-transformAFMImageForNetworkAnalysis(AFMImageNetworksAnalysis=AFMIA,AFMImage= AFMImage)
AFMIA<-identifyNodesAndEdges(cl=cl,AFMImageNetworksAnalysis= AFMIA,maxHeight= 300)
AFMIA<-identifyEdgesFromCircles(cl=cl,AFMImageNetworksAnalysis= AFMIA, MAX_DISTANCE = 75)
AFMIA<-identifyIsolatedNodes(AFMIA)
AFMIA<-createGraph(AFMIA)
AFMIA<-calculateShortestPaths(cl=cl, AFMImageNetworksAnalysis=AFMIA)
AFMIA<-calculateNetworkParameters(AFMImageNetworksAnalysis=AFMIA, AFMImage=AFMImage)
AFMIA<-calculateHolesCharacteristics(AFMImageNetworksAnalysis=AFMIA)
stopCluster(cl)
}
}
\author{
M.Beauvais
}
