% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMImage.R
\name{extractAFMImage}
\alias{extractAFMImage}
\title{Extract a portion of an AFM image.}
\usage{
extractAFMImage(AFMImage, cornerX, cornerY, size)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}

\item{cornerX}{horizontal coordinates of the extract}

\item{cornerY}{vertical coordinates of the extract}

\item{size}{square size of the extract in number of pixels}
}
\value{
a new  \code{\link{AFMImage}} sample
}
\description{
The extract will be a square of the specified size.
If the size is too large for the original \code{\link{AFMImage}}, only the biggest valid size will be kept.
}
\details{
\code{extractAFMImage} returns an extract of the AFMImage
}
\examples{
data(AFMImageOfAluminiumInterface)
anAFMImageExtract<-extractAFMImage(AFMImageOfAluminiumInterface,15,15,256)

}
\author{
M.Beauvais
}
