% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADP.R
\name{adp.t}
\alias{adp.t}
\title{Calculates the predicted adoption probability according to the triers' rate}
\source{
Kislev, Mickey M. & Kislev, Shira, (2020). The Market Trajectory of a
Radically New Product: E-Cigarettes. IJMS 12(4):63-92, DOI:\href{https://www.ccsenet.org/journal/index.php/ijms/article/view/0/44285}{10.5539/ijms.v12n4p63}
}
\usage{
adp.t(triers)
}
\arguments{
\item{triers}{a vector of percentige (0<triers<1) of known triers}
}
\value{
a vector of predicted percentige(0<ADP<1) of the adoption probability
of a innovative product in the population.
}
\description{
#' This function develops a prediction of the adoption rate of an innovation in
the market, according to the number of triers
}
\details{
This function calculates the adoption probability in the population of a certain
innovation according to known triers rate measured in a survey.
}
\examples{
# 50\% rate of triers
adp.t(0.5)
0.4910082
# means that half of the those who will try the product, eventually will adopt the product
}
\seealso{
\code{\link{pusers}}, \code{\link{ptriers}}, and \code{\link{adp.u}}
}
\author{
Mickey Kislev and Shira Kislev
}
