% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parallel.R
\name{CVP_RIDGE}
\alias{CVP_RIDGE}
\title{Parallel Ridge CV (uses CVP_RIDGEc)}
\usage{
CVP_RIDGE(X = NULL, lam = 10^seq(-2, 2, 0.1), K = 5, cores = 1,
  trace = c("none", "progress", "print"))
}
\arguments{
\item{X}{nxp data matrix. Each row corresponds to a single observation and each column contains n observations of a single feature/variable.}

\item{lam}{positive tuning parameters for ridge penalty. If a vector of parameters is provided, they should be in increasing order. Defaults to grid of values \code{10^seq(-2, 2, 0.1)}.}

\item{K}{specify the number of folds for cross validation.}

\item{cores}{option to run CV in parallel. Defaults to \code{cores = 1}.}

\item{trace}{option to display progress of CV. Choose one of \code{progress} to print a progress bar, \code{print} to print completed tuning parameters, or \code{none}.}
}
\value{
returns list of returns which includes:
\item{lam}{optimal tuning parameter.}
\item{min.error}{minimum average cross validation error for optimal parameters.}
\item{avg.error}{average cross validation error across all folds.}
\item{cv.error}{cross validation errors (negative validation likelihood).}
}
\description{
Parallel implementation of cross validation for RIDGEsigma.
}
\keyword{internal}
