#################################################################
# 
# File:         ad.test.pvalue.r
# Purpose:      Gets the p-value for an Anderson Darling GoF test
#
# Created:      20090625
# Author:       Carlos J. Gil Bellosta
#
# Modifications: 
#
#################################################################

ad.test.pvalue <- function( x, n )
{
    if( x < 2 )
        x <- exp(-1.2337141/x)/sqrt(x)*(2.00012+(.247105- (.0649821-(.0347962-(.011672-.00168691*x)*x)*x)*x)*x)
    else
        x <- exp(-exp(1.0776-(2.30695-(.43424-(.082433-(.008056 -.0003146*x)*x)*x)*x)*x))


    if( x > 0.8 )
        return( x + (-130.2137+(745.2337-(1705.091-(1950.646-(1116.360-255.7844*x)*x)*x)*x)*x)/n )
    
    z <- 0.01265 + 0.1757 / n

    if( x < z ){ 
        v <- x / z
        v <- sqrt(v)*(1.-v)*(49*v-102)
        return ( x + v * (.0037/(n*n)+.00078/n+.00006)/n )
    }

    v <- (x-z) / (0.8-z)
    v <- -0.00022633+(6.54034-(14.6538-(14.458-(8.259-1.91864*v)*v)*v)*v)*v
    x + v * (.04213+.01365/n)/n
}
