% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_col_names}
\alias{check_col_names}
\title{Check if a column name already exists in a data frame}
\usage{
check_col_names(data, names)
}
\arguments{
\item{data}{tbl. Data frame to check for the column name.}

\item{names}{character vector, The name(s) of the column to check for.}
}
\value{
NULL. The function will abort with an error if the column name
already exists.
}
\description{
This function checks if a column name already exists in a data frame.
If the column name already exists, the function will abort with an error.
}
\examples{
data <- tibble::tibble(a = NA, b = NA, c = NA)
try({
  check_col_names(data, c("a", "b", "c"))
  check_col_names(data, c("a", "d"))
})
}
\keyword{internal}
