% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fitArCo.R
\name{plot.fitArCo}
\alias{plot.fitArCo}
\title{Plots realized values and the counterfactual estimated by the fitArCo function}
\usage{
\method{plot}{fitArCo}(x, ylab = NULL, main = NULL, plot = NULL,
  ncol = 1, display.fitted = FALSE, y.min = NULL, y.max = NULL,
  confidence.bands = FALSE, alpha = 0.05, ...)
}
\arguments{
\item{x}{An ArCo object estimated using the fitArCo function.}

\item{ylab}{n dimensional character vector, where n is the length of the plot argument or n=q if plot=NULL.}

\item{main}{n dimensional character vector, where n is the length of the plot argument or n=q if plot=NULL.}

\item{plot}{n dimensional numeric vector where each element represents an ArCo unit. If NULL, all units will be plotted. If, for example, plot=c(1,2,5) only units 1 2 and 5 will be plotted according to the order specified by the user on the fitArCo.}

\item{ncol}{Number of columns when multiple plots are displayed.}

\item{display.fitted}{If TRUE the fitted values of the first step estimation are also plotted (default=FALSE).}

\item{y.min}{n dimensional numeric vector defining the lower bound for the y axis. n is the length of the plot argument or n=q if plot=NULL}

\item{y.max}{n dimensional numeric vector defining the upper bound for the y axis. n is the length of the plot argument or n=q if plot=NULL}

\item{confidence.bands}{TRUE to plot the counterfactual confidence bands (default=FALSE). If the ArCo was estimated without bootstrap this argument will be forced to FALSE.}

\item{alpha}{Significance level for the confidence bands.}

\item{...}{Other graphical parameters to plot.}
}
\description{
Plots realized values and the counterfactual estimated by the fitArCo function. The plotted variables will be on the same level as supplied to the fitArCo function.
}
\examples{
##############################################
## === Example based on the q=1 fitArCo === ##
##############################################
# = First unit was treated on t=51 by adding
# a constant equal to one standard deviation
data(data.q1)
data=list(data.q1) # = Even if q=1 the data must be in a list
## == Fitting the ArCo using linear regression == ##
# = creating fn and p.fn function = #
fn=function(X,y){
return(lm(y~X))
}
p.fn=function(model,newdata){
b=coef(model)
return(cbind(1,newdata) \%*\% b)}
ArCo=fitArCo(data = data,fn = fn, p.fn = p.fn, treated.unit = 1 , t0 = 51)
plot(ArCo)
}
\seealso{
\code{\link{fitArCo}}
}
