% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redux2isoplotr.R
\name{redux2isoplotr}
\alias{redux2isoplotr}
\title{Export \code{ArArRedux} data to \code{IsoplotR}}
\usage{
redux2isoplotr(x, irr, fract = NULL, ca = NULL, k = NULL, format = 1,
  file = NULL)
}
\arguments{
\item{x}{an object of class \code{\link{redux}}}

\item{irr}{the irradiation schedule}

\item{fract}{list with air shot data (one item per denominator
isotope)}

\item{ca}{an object of class \code{\link{logratios}} with
Ca-interference data (not necessary if interferences are
included in X)}

\item{k}{an object of class \code{\link{logratios}} with
K-interference data (not necessary if interferences are
included in X)}

\item{format}{input format for \code{IsoplotR}. I.e. one of

\code{1}: 39/40, s[39/40], 36/40, s[36/40], 39/36, s[39/36]

(other formats will be added later)}

\item{file}{optional (\code{.csv}) file name to write the output
to.}
}
\value{
an object of class \code{ArAr}, i.e. a table with the
    following columns: \code{'Ar4036'}, \code{'errAr4036'},
    \code{'Ar3936'}, \code{'errAr3936'}, \code{'Ar4039'}, and
    \code{'errAr4039'}
}
\description{
Creates a data object compatible with the \code{IsoplotR} package
}
\examples{
data(Melbourne)
print(redux2isoplotr(Melbourne$X,Melbourne$irr))
}
