% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_distance_boxplot.R
\name{Af_distance_boxplot}
\alias{Af_distance_boxplot}
\title{Function to make a grouped boxplot of distance between nodes from specific groups and the germline of lineage trees constructed with AntibodyForests.}
\usage{
Af_distance_boxplot(
  AntibodyForests_object,
  distance,
  min.nodes,
  groups,
  node.feature,
  unconnected,
  colors,
  text.size,
  x.label,
  group.order,
  significance,
  parallel,
  output.file
)
}
\arguments{
\item{AntibodyForests_object}{AntibodyForests-object, output from Af_build()}

\item{distance}{\itemize{
\item string - How to calculate the distance to the germline.
'node.depth'     : Average of the sum of edges on the shortest parth between germline and nodes from this group.
'edge.length'    : Average of the sum of edge length of the shortest path between germline and nodes from this group. (Default)
}}

\item{min.nodes}{The minimum number of nodes for a tree to be included in this analysis (this included the germline)}

\item{groups}{Which groups to compare. These groups need to be in the node features of the AntibodyForests-object. Set to NA if all features should displayed. (default is NA)
If you want to compare IgM and IgG for example, groups should be c("IgM, "IgG") (not "Isotypes")}

\item{node.feature}{Node feature in the AntibodyForests-object to compare.}

\item{unconnected}{If TRUE, trees that don't have all groups will be plotted, but not included in significance analysis. (default FALSE)}

\item{colors}{Optionally specific colors for the group (Will be matched to the groups/names on alphabetical order).}

\item{text.size}{Font size in the plot (default 20).}

\item{x.label}{Label for the x-axis (default is the node feature).}

\item{group.order}{Order of the groups on the x-axis. (default is alphabetical/numerical)}

\item{significance}{If TRUE, the significance of the difference (paired t-test) between the groups is plotted. (default FALSE)}

\item{parallel}{If TRUE, the metric calculations are parallelized across clonotypes. (default FALSE)}

\item{output.file}{string - specifies the path to the output file (PNG of PDF). Defaults to NULL.}
}
\value{
A ggplot2 object with the boxplot.
}
\description{
Function to compare trees.
}
\examples{
Af_distance_boxplot(AntibodyForests::small_af,
                    distance = "edge.length",
                    min.nodes = 5,
                    groups = c("IGHA", "IgG1"),
                    node.feature = "isotype",
                    unconnected = TRUE)

}
