% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AmyloGram-package.R
\docType{package}
\name{AmyloGram-package}
\alias{AmyloGram-package}
\alias{AmyloGram}
\title{Prediction of amyloids}
\description{
Amyloids are proteins associated with the number of clinical disorders (e.g.,
Alzheimer's, Creutzfeldt-Jakob's and Huntington's diseases). Despite their
diversity, all amyloid proteins can undergo aggregation initiated by 6- to
15-residue segments called hot spots. Henceforth, amyloids form unique,
zipper-like beta-structures, which are often harmful. To find the patterns
defining the hot spots, we developed our novel predictor of amyloidogenicity
AmyloGram, based on random forests.
}
\details{
AmyloGram is available as R function (\code{\link{predict.ag_model}}) or
shiny GUI (\code{\link{AmyloGram_gui}}).

The package is enriched with the benchmark data set \code{\link{pep424}}.
}
\references{
Burdukiewicz MJ, Sobczyk P, Roediger S, Duda-Madej A,
Mackiewicz P, Kotulska M. (2017) \emph{Amyloidogenic motifs revealed
by n-gram analysis}. Scientific Reports 7
\url{https://doi.org/10.1038/s41598-017-13210-9}
}
\author{
Maintainer: Michal Burdukiewicz <michalburdukiewicz@gmail.com>
}
\keyword{package}
