% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{loadEstimates.mirt.grm}
\alias{loadEstimates.mirt.grm}
\title{Estimate \code{mirt} models using aligned parameter estimates}
\usage{
loadEstimates.mirt.grm(
  fit,
  align.mean,
  align.variance,
  newpars,
  do.fit = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{fit}{A \code{mirt} object compatible with \code{\link{Alignment}}}

\item{align.mean}{Mean to transform model to.}

\item{align.variance}{Variance to transform model to.}

\item{newpars}{New (transformed) estimates to load into model object.}

\item{do.fit}{Whether to re-fit the model after loading and fixing estimates.}

\item{verbose}{See \code{\link{Alignment}} documentation.}
}
\value{
A \code{mirt}, object based on \code{fit} but with modified
parameters.
}
\description{
Not generally intended to be used on its own, but exported anyway for
didactic purposes.
}
\details{
See example for \code{\link{Alignment}} for examples

This program was designed based on the published work of Asparouhov & Muthen,
and was not intended to match Mplus exactly, and may not.
}
