# AlgeriAPIs - Access Algerian Data via Public APIs
# Version 0.1.0
# Copyright (c) 2025 Renzo Caceres Rossi
# Licensed under the MIT License.
# See the LICENSE file in the root directory for full license text.

# view_datasets_AlgeriAPIs

library(testthat)
library(AlgeriAPIs)

test_that("view_datasets_AlgeriAPIs works when package is loaded", {
  result <- view_datasets_AlgeriAPIs()
  expect_type(result, "character")
  expect_true(length(result) > 0)
})

test_that("view_datasets_AlgeriAPIs prints correct message", {
  output <- capture_messages(view_datasets_AlgeriAPIs())
  expect_match(
    output[1],
    "Datasets available in the 'AlgeriAPIs' package:",
    fixed = TRUE
  )
})

test_that("view_datasets_AlgeriAPIs returns expected datasets", {
  datasets <- view_datasets_AlgeriAPIs()
  expected_datasets <- c(
    "algiers_temp_df",
    "internet_users_tbl_df"


  )
  # Check if all expected datasets are present
  missing_datasets <- setdiff(expected_datasets, datasets)
  expect_true(
    length(missing_datasets) == 0,
    info = paste("Missing datasets:", paste(missing_datasets, collapse = ", "))
  )
})
