% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markmet.R
\name{markmet}
\alias{markmet}
\title{Spray deposit (metallic marker)}
\usage{
markmet(
  ppm,
  white,
  VL,
  AL,
  analysis = TRUE,
  trat,
  block,
  design = "DIC",
  transf = 1,
  quali = TRUE,
  grau = 1,
  test = "parametric",
  mcomp = "tukey",
  ylab = expression(mu ~ cm^2),
  save.xlsx = FALSE
)
}
\arguments{
\item{ppm}{Concentração}

\item{white}{White reading}

\item{VL}{Wah volume (mL)}

\item{AL}{blade area (cm2)}

\item{analysis}{Perform statistical analysis}

\item{trat}{Vector with treatment}

\item{block}{Vector with block (if design = "DBC")}

\item{design}{Experiment design}

\item{transf}{Data transformation}

\item{quali}{Qualitative or quantitative treatment (\emph{default} is TRUE)}

\item{grau}{degree of the polynomial (when treatment is quantitative)}

\item{test}{Parametric or Nonparametric (\emph{default} is "parametric")}

\item{mcomp}{Mean comparison test (\emph{default} is "tukey")}

\item{ylab}{y axis name (\emph{default} is expression(mu~cm^2))}

\item{save.xlsx}{Want to export in excel format (\emph{default} is FALSE)}
}
\value{
Returns the comparison between the treatments of the experiment
}
\description{
This is a function to determine spray deposit using metallic markers and then after performing tests of assumptions, analysis of variance and comparison of means
}
\examples{
library(AgroTech)
data("example_markmet")
with(example_markmet,
     markmet(ppm = ppm,
            white = 0.02,
            VL = 35,
            AL = 63.61,
            analysis = TRUE,
            trat=trat))
}
\references{
No reference
}
\seealso{
\link{markblue}
}
\author{
Rodrigo Yudi Palhaci Marubayashi, \email{marubayashi@uel.br}

Gabriel Danilo Shimizu

Otavio Jorge Grigoli Abi Saab
}
