% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calAIAdj.R
\name{aiAdj}
\alias{aiAdj}
\title{aiAdj}
\usage{
aiAdj(object, x)
}
\arguments{
\item{object}{ai object from ai function}

\item{x}{A numeric value or a vector of numeric values to calculate bias-adjusted average interval for}
}
\value{
bias-adjusted and total-adjusted average interval for each value in \code{x}
}
\description{
Function aiAdj calculates bias-adjusted average interval from ai object
}
\details{
Function aiAdj uses proportional bias per \code{x} unit, Liao's average interval,
Liao's average interval adjusted for fixed bias to calculate bias-adjusted and total-adjusted average interval.
}
\examples{
ans <- ai(x=IPIA$Tomography, y=IPIA$Urography)
aiAdj(object=ans, x=1)
aiAdj(object=ans, x=c(1, 2))
}
\references{
Jason J. Z. Liao, Quantifying an Agreement Study, Int. J. Biostat. 2015; 11(1): 125-133
}
\author{
Jialin Xu, Jason Liao
}
