% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASSISTDesigns.R
\name{ASSISTDesignB}
\alias{ASSISTDesignB}
\title{A fixed sample design to compare against the adaptive clinical
trial design}
\description{
\code{ASSISTDesignB} objects are used to design a trial
with certain characteristics provided in the object instantiation
method. This design differs from \code{ASSISTDesign} in only how it
computes the critical boundaries, how it performs the interim
look, and what quantities are computed in a trial run.
}
\examples{
\dontrun{
data(LLL.SETTINGS)
prevalence <- LLL.SETTINGS$prevalences$table1
scenario <- LLL.SETTINGS$scenarios$S0
designParameters <- list(prevalence = prevalence,
                       mean = scenario$mean,
                       sd = scenario$sd)
designB <- ASSISTDesignB$new(trialParameters = LLL.SETTINGS$trialParameters,
                            designParameters = designParameters)
print(designB)
## A realistic design uses 5000 simulations or more!
result <- designB$explore(showProgress = interactive())
analysis <- designB$analyze(result)
designB$summary(analysis)
}
## For full examples, try:
## browseURL(system.file("full_doc/ASSISTant.html", package="ASSISTant"))

}
\seealso{
\code{ASSISTDesign} which is a superclass of this object
}
\section{Super class}{
\code{\link[ASSISTant:ASSISTDesign]{ASSISTant::ASSISTDesign}} -> \code{ASSISTDesignB}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ASSISTDesignB-computeCriticalValues}{\code{ASSISTDesignB$computeCriticalValues()}}
\item \href{#method-ASSISTDesignB-explore}{\code{ASSISTDesignB$explore()}}
\item \href{#method-ASSISTDesignB-analyze}{\code{ASSISTDesignB$analyze()}}
\item \href{#method-ASSISTDesignB-summary}{\code{ASSISTDesignB$summary()}}
\item \href{#method-ASSISTDesignB-clone}{\code{ASSISTDesignB$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="getBoundaries"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-getBoundaries'><code>ASSISTant::ASSISTDesign$getBoundaries()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="getDesignParameters"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-getDesignParameters'><code>ASSISTant::ASSISTDesign$getDesignParameters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="getTrialParameters"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-getTrialParameters'><code>ASSISTant::ASSISTDesign$getTrialParameters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="initialize"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-initialize'><code>ASSISTant::ASSISTDesign$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="performInterimLook"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-performInterimLook'><code>ASSISTant::ASSISTDesign$performInterimLook()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="print"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-print'><code>ASSISTant::ASSISTDesign$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="setBoundaries"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-setBoundaries'><code>ASSISTant::ASSISTDesign$setBoundaries()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesignB-computeCriticalValues"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesignB-computeCriticalValues}{}}}
\subsection{Method \code{computeCriticalValues()}}{
Compute the critical boundary value \eqn{c_\alpha}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesignB$computeCriticalValues()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a named vector of a single value containing the value for \code{c}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesignB-explore"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesignB-explore}{}}}
\subsection{Method \code{explore()}}{
Explore the design using the specified number of simulations, random number seed, and
further parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesignB$explore(
  numberOfSimulations = 100,
  rngSeed = 12345,
  trueParameters = self$getDesignParameters(),
  showProgress = TRUE,
  saveRawData = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{numberOfSimulations}}{default number of simulations is 100}

\item{\code{rngSeed}}{default seed is 12345}

\item{\code{trueParameters}}{the state of nature, by default the value of \code{self$getDesignParameters()} as would be the case for a Type I error calculation. If changed, would yield power.}

\item{\code{showProgress}}{a boolean flag to show progress, default \code{TRUE}}

\item{\code{saveRawData}}{a flag (default \code{FALSE}) to indicate if raw data has to be saved}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list of results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesignB-analyze"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesignB-analyze}{}}}
\subsection{Method \code{analyze()}}{
Analyze the exploration data from trial
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesignB$analyze(trialExploration)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{trialExploration}}{the result of a call to \code{explore()} to simulate the design}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Return a list of summary quantities
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesignB-summary"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesignB-summary}{}}}
\subsection{Method \code{summary()}}{
Print the operating characteristics of the design using the analysis data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesignB$summary(analysis)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{analysis}}{the analysis result from the \code{analyze()} call}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesignB-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesignB-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesignB$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
