\name{datavalidation}
\alias{datavalidation}
\docType{data}
\title{
Data Sets~~
}
\description{
Data.frame with data for calculating the quality parameters of a technique for the measurement of a chemical component of water with the validation() function. The data.frame includes concentration and absorbance measurement of standards of the calibration curve and a solution of known concentration, called quality control (qc). The data.frame includes measurements of the absorbance of the tube at three different days.
Column 1: name of the tube. The tubes b, s1, s2,s3 and s4 represent different concentrations of a calibration curve.  
Column 2: concentration: the concentration of each tube, expressed in micrograms.
Column 3: abs: absorbance of each tube which were measured spectrophotometrically.
Column 4: day: the day when the measurement was done.
}
\usage{data("datavalidation")}
\format{
  A data frame with 46 measurement of the following variables.
  \describe{
    \item{\code{tube}}{a character vector}
    \item{\code{concentration}}{a numeric vector}
    \item{\code{abs}}{a numeric vector}
    \item{\code{day}}{a numeric vector}
   }
}

\examples{
# Including data.frame: datavalidation in workspace.
data("datavalidation")
# Column names of data.frame: datavalidation
names(datavalidation) 
# Data set type of columns of data.frame: datavalidation.
str(datavalidation)
# Calculation of quality parameters of the Total Kjeldhal Nitrogen (tkn) measurement technique
validation(datavalidation,numest=4,measurementunit='ug',techniquename='tkn',graph=TRUE)
}

\keyword{datasets}