% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{apci.bar}
\alias{apci.bar}
\title{Make barplot for cohort effect}
\usage{
apci.bar(model, age, period, outcome_var, cohort_label = NULL, ...)
}
\arguments{
\item{model}{A list recording the results from function \code{apci}.}

\item{age}{An object of class character representing the age group index
taking on a small number of distinct values in the data. Usually, the vector
should be converted to a factor (or the terms of "category" and "enumerated
type").}

\item{period}{An object of class character, similar to the argument of age,
representing the time period index in the data.}

\item{outcome_var}{An object of class character indicating
the name of the outcome variable used in the model. The
outcome variable can be a continuous, binary, categorical, or count variable.}

\item{cohort_label}{An optional vector, representing the labels of
cohort groups in the x asix.}

\item{\dots}{Additional arguments to be passed to the function.}
}
\value{
A bar plot visualizing the cohort effects estimated by APC-I model.
}
\description{
Visualize cohort effects estimated by APC-I model with bar plots.
}
\examples{
# load package
library("APCI")
# load data
test_data <- APCI::women9017
test_data$acc <- as.factor(test_data$acc)
test_data$pcc <- as.factor(test_data$pcc)
test_data$educc <- as.factor(test_data$educc)
test_data$educr <- as.factor(test_data$educr)

# fit APC-I model
APC_I <- APCI::apci(outcome = "inlfc",
                    age = "acc",
                    period = "pcc",
                    cohort = "ccc",
                    weight = "wt",
                    data = test_data,dev.test=FALSE,
                    print = TRUE,
                    family = "gaussian")
summary(APC_I)

## visualizing estimated cohort effects with bar plot
apci.bar(model = APC_I, age = "acc", period = "pcc")
}
