% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivotal.R
\name{rGPQ}
\alias{rGPQ}
\title{Generalized pivotal quantities}
\usage{
rGPQ(fit, n = 10000)
}
\arguments{
\item{fit}{an \code{\link{aov1r}} object}

\item{n}{number of simulations}
}
\value{
The simulations in a dataframe.
}
\description{
Simulates from the generalized pivotal quantities.
}
\examples{
dat <- simAOV1R(I=20, J=5, mu=10, sigmab=1, sigmaw=1)
fit <- aov1r(y ~ group, data=dat)
nsims <- 20000
pivsims <- rGPQ(fit, nsims)
pivsims$GPQ_sigma2tot <- pivsims$GPQ_sigma2b + pivsims$GPQ_sigma2w
# Generalized confidence intervals:
lapply(pivsims, quantile, probs = c(0.025, 0.975))
# compare with the frequentist confidence intervals:
confint(fit, SDs = FALSE)
# Generalized prediction interval:
with(
  pivsims,
  quantile(rnorm(nsims, GPQ_mu, sqrt(GPQ_sigma2tot)),
           probs = c(0.025, 0.975))
)
# compare with the frequentist prediction interval:
predict(fit)
}
\references{
Samaradasa Weerahandi.
\emph{Exact Statistical Methods for Data Analysis}.
Springer, New York, NY (1995).
<doi:10.1007/978-1-4612-0825-9>
}
