# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Check which prevalence samples are valid for each location at each time point.
#' @param prevalence_map List where each element is prevalence_map data for a time point.
#' @param boundaries Vector of length two.
#' @param sd Parameter sigma of the Gaussian kernel.
#' @return An (n_tims x n_locs x m) array.
#' @noRd
calc_log_norm_const_gaussian <- function(prevalence_map, boundaries, sd) {
    .Call('_AMISforInfectiousDiseases_calc_log_norm_const_gaussian', PACKAGE = 'AMISforInfectiousDiseases', prevalence_map, boundaries, sd)
}

#' @title  Compute weight matrix using empirical Radon-Nikodym derivative (Rcpp version) and Gaussian kernel
#' @description Compute matrix describing the weights for each parameter sampled, for each
#' location. One row per sample, one column per location.  Each weight 
#' is computed based on the empirical Radon-Nikodym derivative, taking into account 
#' geostatistical prevalence data for the specific location and the prevalence values 
#' computed from the transmission model for the specific parameter sample.
#' @param likelihoods An n_sims x n_locs matrix of (log-)likelihoods
#' NB: transpose of slice of array. 
#' @param prev_sim A vector containing the simulated prevalence value for each parameter sample.
#' @param amis_params A list of parameters, e.g. from \code{\link{default_amis_params}}
#' @param weight_matrix An n_sims x n_locs matrix containing the current values of the weights.
#' @param which_valid_sim_prev Vector showing which simulated values are valid.
#' @param which_invalid_sim_prev Vector showing which simulated values are invalid.
#' @param locs Vector showing which locations have data.
#' @return An updated weight matrix.
#' @noRd
compute_weight_matrix_empirical_gauss <- function(likelihoods, prev_sim, amis_params, weight_matrix, which_valid_sim_prev, which_invalid_sim_prev, locs) {
    .Call('_AMISforInfectiousDiseases_compute_weight_matrix_empirical_gauss', PACKAGE = 'AMISforInfectiousDiseases', likelihoods, prev_sim, amis_params, weight_matrix, which_valid_sim_prev, which_invalid_sim_prev, locs)
}

#' @title  Compute weight matrix using empirical Radon-Nikodym derivative (Rcpp version)
#' @description Compute matrix describing the weights for each parameter sampled, for each
#' location. One row per sample, one column per location.  Each weight 
#' is computed based on the empirical Radon-Nikodym derivative, taking into account 
#' geostatistical prevalence data for the specific location and the prevalence values 
#' computed from the transmission model for the specific parameter sample.
#' @param likelihoods An n_sims x n_locs matrix of (log-)likelihoods
#' NB: transpose of slice of array. 
#' @param prev_sim A vector containing the simulated prevalence value for each parameter sample.
#' @param amis_params A list of parameters, e.g. from \code{\link{default_amis_params}}
#' @param weight_matrix An n_sims x n_locs matrix containing the current values of the weights.
#' @param bool_valid_sim_prev Logical vector showing which simulated values are valid.
#' @param which_valid_sim_prev Vector showing which simulated values are valid.
#' @param which_invalid_sim_prev Vector showing which simulated values are invalid.
#' @param locs Vector showing which locations have data.
#' @return An updated weight matrix.
#' @noRd
compute_weight_matrix_empirical_histogram <- function(likelihoods, prev_sim, amis_params, weight_matrix, bool_valid_sim_prev, which_valid_sim_prev, which_invalid_sim_prev, locs) {
    .Call('_AMISforInfectiousDiseases_compute_weight_matrix_empirical_histogram', PACKAGE = 'AMISforInfectiousDiseases', likelihoods, prev_sim, amis_params, weight_matrix, bool_valid_sim_prev, which_valid_sim_prev, which_invalid_sim_prev, locs)
}

#' @title  Compute weight matrix using empirical Radon-Nikodym derivative (Rcpp version)
#' @description Compute matrix describing the weights for each parameter sampled, for each
#' location. One row per sample, one column per location.  Each weight 
#' is computed based on the empirical Radon-Nikodym derivative, taking into account 
#' geostatistical prevalence data for the specific location and the prevalence values 
#' computed from the transmission model for the specific parameter sample.
#' @param likelihoods An n_sims x n_locs matrix of (log-)likelihoods
#' NB: transpose of slice of array. 
#' @param prev_sim A vector containing the simulated prevalence value for each parameter sample.
#' @param amis_params A list of parameters, e.g. from \code{\link{default_amis_params}}
#' @param weight_matrix An n_sims x n_locs matrix containing the current values of the weights.
#' @param bool_valid_sim_prev Logical vector showing which simulated values are valid.
#' @param which_valid_sim_prev Vector showing which simulated values are valid.
#' @param which_invalid_sim_prev Vector showing which simulated values are invalid.
#' @param locs Vector showing which locations have data.
#' @return An updated weight matrix.
#' @noRd
compute_weight_matrix_empirical_uniform <- function(likelihoods, prev_sim, amis_params, weight_matrix, bool_valid_sim_prev, which_valid_sim_prev, which_invalid_sim_prev, locs) {
    .Call('_AMISforInfectiousDiseases_compute_weight_matrix_empirical_uniform', PACKAGE = 'AMISforInfectiousDiseases', likelihoods, prev_sim, amis_params, weight_matrix, bool_valid_sim_prev, which_valid_sim_prev, which_invalid_sim_prev, locs)
}

#' @title  Compute weight matrix without using induced prior
#' @description Compute matrix describing the weights for each parameter sampled, for each
#' location. One row per sample, one column per location.  Each weight 
#' is computed based on the empirical Radon-Nikodym derivative, taking into account 
#' geostatistical prevalence data for the specific location and the prevalence values 
#' computed from the transmission model for the specific parameter sample.
#' @param likelihoods An n_sims x n_locs matrix of (log-)likelihoods
#' NB: transpose of slice of array. 
#' @param amis_params A list of parameters, e.g. from \code{\link{default_amis_params}}
#' @param weight_matrix An n_sims x n_locs matrix containing the current values of the weights.
#' @param which_valid_sim_prev Vector showing which simulated values are valid.
#' @param which_invalid_sim_prev Vector showing which simulated values are invalid.
#' @param locs Vector showing which locations have data.
#' @return An updated weight matrix.
#' @noRd
compute_weight_matrix_without_g <- function(likelihoods, amis_params, weight_matrix, which_valid_sim_prev, which_invalid_sim_prev, locs) {
    .Call('_AMISforInfectiousDiseases_compute_weight_matrix_without_g', PACKAGE = 'AMISforInfectiousDiseases', likelihoods, amis_params, weight_matrix, which_valid_sim_prev, which_invalid_sim_prev, locs)
}

#' @title Empirical estimator for the likelihood using Gaussian kernel
#' @param prevalence_map An L x M matrix containing samples from the fitted prevalence map.
#' @param prev_sim A vector containing the simulated prevalence value for each parameter sample.
#' @param sd Bandwith value.
#' @param which_valid_sim_prev_iter Vector showing which simulated values are valid.
#' @param which_valid_prev_map_t List showing which samples are valid for each location at a time point. 
#' @param log_norm_const_gaussian_t (n_locs x M) matrix showing the log normalising constant for the Gaussian kernels.
#' @return A matrix with L rows containing the empirical estimates for the likelihood.
#' @noRd
f_estimator_Gaussian <- function(prevalence_map, prev_sim, sd, which_valid_sim_prev_iter, which_valid_prev_map_t, log_norm_const_gaussian_t, logar) {
    .Call('_AMISforInfectiousDiseases_f_estimator_Gaussian', PACKAGE = 'AMISforInfectiousDiseases', prevalence_map, prev_sim, sd, which_valid_sim_prev_iter, which_valid_prev_map_t, log_norm_const_gaussian_t, logar)
}

#' @title Empirical estimator for the likelihood using Uniform kernel
#' @param prevalence_map An L x M matrix containing samples from the fitted prevalence map.
#' @param prev_sim A vector containing the simulated prevalence value for each parameter sample.
#' @param breaks vector specifying the breaks for the histogram.
#' @param which_valid_prev_map_t List showing which samples are valid for each location at a time point. 
#' @return A matrix with L rows containing the empirical estimates for the likelihood.
#' @noRd
f_estimator_histogram <- function(prevalence_map, prev_sim, breaks, which_valid_prev_map_t, logar) {
    .Call('_AMISforInfectiousDiseases_f_estimator_histogram', PACKAGE = 'AMISforInfectiousDiseases', prevalence_map, prev_sim, breaks, which_valid_prev_map_t, logar)
}

#' @title Empirical estimator for the likelihood using Uniform kernel
#' @param prevalence_map An L x M matrix containing samples from the fitted prevalence map.
#' @param prev_sim A vector containing the simulated prevalence value for each parameter sample.
#' @param delta Bandwidth value.
#' @param which_valid_sim_prev_iter Vector showing which simulated values are valid.
#' @param which_valid_prev_map_t List showing which samples are valid for each location at a time point. 
#' @param boundaries Vector of length two.
#' @return A matrix with L rows containing the empirical estimates for the likelihood.
#' @noRd
f_estimator_uniform <- function(prevalence_map, prev_sim, delta, which_valid_sim_prev_iter, which_valid_prev_map_t, boundaries, logar) {
    .Call('_AMISforInfectiousDiseases_f_estimator_uniform', PACKAGE = 'AMISforInfectiousDiseases', prevalence_map, prev_sim, delta, which_valid_sim_prev_iter, which_valid_prev_map_t, boundaries, logar)
}

#' @title Calculates an (n_locs x n_sims) matrix of likelihood values using a parametric likelihood function
#' @param likelihood_fun User-defined parametric likelihood function.
#' @param prevalence_map An (n_locs x M) matrix, where M is the number of samples from a geostatistical model 
#' or the number of likelihood parameters.
#' @param which_valid_prev_map_t List showing which samples are valid for each location at a time point.
#' @param prev_sim A vector containing the simulated prevalence value for each parameter sample.
#' @param which_valid_sim_prev_iter Vector showing which simulated values are valid.
#' @param logar Logical indicating if the outputs should be in log-scale or not
#' @return An (n_locs x n_sims) matrix with the parametric likelihood function evaluated at the simulated prevalences.
#' @noRd
f_user_defined <- function(likelihood_fun, prevalence_map, which_valid_prev_map_t, prev_sim, which_valid_sim_prev_iter, logar) {
    .Call('_AMISforInfectiousDiseases_f_user_defined', PACKAGE = 'AMISforInfectiousDiseases', likelihood_fun, prevalence_map, which_valid_prev_map_t, prev_sim, which_valid_sim_prev_iter, logar)
}

#' @title Check which prevalence samples are valid for each location at each time point.
#' @param prevalence_map List where each element is prevalence_map data for a time point.
#' @param boundaries Vector of length two.
#' @return A list where each element corresponds to a time point. For each time point, there will 
#' be a list of n_locs elements, where each one shows which samples (out of M) are valid. 
#' @noRd
get_which_valid_prev_map <- function(prevalence_map, boundaries) {
    .Call('_AMISforInfectiousDiseases_get_which_valid_prev_map', PACKAGE = 'AMISforInfectiousDiseases', prevalence_map, boundaries)
}

#' @title Check, at each time, which locations have valid data
#' @param which_valid_prev_map List obtained by get_which_valid_prev_map
#' @param n_tims Number of time points
#' @param n_locs Number of locations
#' @noRd
get_which_valid_locs_prev_map <- function(which_valid_prev_map, n_tims, n_locs) {
    .Call('_AMISforInfectiousDiseases_get_which_valid_locs_prev_map', PACKAGE = 'AMISforInfectiousDiseases', which_valid_prev_map, n_tims, n_locs)
}

#' @title Determine first time each location appears in the data
#' @param which_valid_locs_prev_map List obtained by get_which_valid_locs_prev_map
#' @param n_tims Number of time points
#' @param n_locs Number of locations
#' @noRd
get_locations_first_t <- function(which_valid_locs_prev_map, n_tims, n_locs) {
    .Call('_AMISforInfectiousDiseases_get_locations_first_t', PACKAGE = 'AMISforInfectiousDiseases', which_valid_locs_prev_map, n_tims, n_locs)
}

#' @title Determine, at which time point, which locations are updated using induced prior
#' @param locations_first_t Vector obtained by locations_first_t
#' @param n_tims Number of time points
#' @noRd
get_locs_with_g <- function(locations_first_t, n_tims) {
    .Call('_AMISforInfectiousDiseases_get_locs_with_g', PACKAGE = 'AMISforInfectiousDiseases', locations_first_t, n_tims)
}

#' @title Determine, at which time point, which locations are updated without using induced prior
#' @param locations_first_t Vector obtained by locations_first_t
#' @param n_tims Number of time points
#' @noRd
get_locs_without_g <- function(locations_first_t, n_tims) {
    .Call('_AMISforInfectiousDiseases_get_locs_without_g', PACKAGE = 'AMISforInfectiousDiseases', locations_first_t, n_tims)
}

