% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALTopt.R
\name{convert.stress.level}
\alias{convert.stress.level}
\title{Coding and decoding stress level}
\usage{
convert.stress.level(lowStLv, highStLv, actual = NULL, stand = NULL)
}
\arguments{
\item{lowStLv}{a numeric vector containing the actual lowest stress level
of each stress variable in design region.}

\item{highStLv}{a numeric vector containing the actual highest stress level
of each stress variable in design region.}

\item{actual}{a data frame or numeric vector containing the design points
in actual units.}

\item{stand}{a data frame or numeric vector containing the design points
in standardized units.}
}
\value{
When \code{actual} is provided, the function converts it to the
  standardized units and when \code{stand} is provided, the function converts
  it to the actual units.
}
\description{
Convert the stress levels from the actual levels to standardized levels,
  and vice versa.
}
\examples{
\dontrun{
  # Generating D optimal design in coded unit.
  Design <- altopt.rc(optType = "D", N = 100, tc = 100, nf = 2, alpha = 1,
  formula = ~x1 + x2 + x1:x2, coef = c(0, -4.086, -1.476, 0.01))

  # Transform the coded unit to actual stress variable's level.
  convert.stress.level(lowStLv = c(34.834, 4.094), highStLv = c(30.288, 4.5),
  stand = Design$opt.design.rounded)

  # Transform the actual stress level to coded units.
  use <- c(38.281, 3.219)
  convert.stress.level(lowStLv = c(34.834, 4.094), highStLv = c(30.288, 4.5),
  actual = use)
  }
}
