% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_mle_beta}
\alias{get_mle_beta}
\title{get_mle_beta}
\usage{
get_mle_beta(b1_hat, b2_hat, c, r, null = TRUE)
}
\arguments{
\item{b1_hat}{estimated effect size of the first phenotype across all variants}

\item{b2_hat}{estimated effect size of the second phenotype across all variants}

\item{c}{slope between the two sets of variant effect sizes, only applicable when `null` == TRUE}

\item{r}{phenotypic correlation between the two phenotypes}

\item{null}{whether to simulate data under the null hypothesis (no linear relationship) or the alternative hypothesis}
}
\value{
A 2x`n_var` matrix of MLE estimated effect size information (first row corresponds to the first phenotype, second row corresponds to the second phenotype)
}
\description{
ALLSPICE function: compute the effect size estimates that maximize the likelihood (maximum likelihood estimate - MLE) conditioning on c
}
\examples{
AC <- get_ac_mat(n_var=100)
A <- get_af_mat(AC=AC, n_ind=10000)
X <- get_geno_mat(AC, n_ind=10000)
b <- get_true_beta(n_var=100, c=0.6, pi=0.5, sigma=1, null=TRUE)
Y <- get_pheno_pair(b=b, X=X, r=0.5)
b_hat <- get_beta_hat(Y=Y, X=X, A=A, n_ind=10000)
b1_hat <- matrix(b_hat[1, ], nrow = 1)
b2_hat <- matrix(b_hat[2, ], nrow = 1)
b_mle <- get_mle_beta(b1_hat=b1_hat, b2_hat=b2_hat, c=0.6, r=0.5, null=TRUE)
}
