% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp_s.R
\name{ahp_s}
\alias{ahp_s}
\title{Calculates the AHP for criteria and subcriteria}
\usage{
ahp_s(base, map)
}
\arguments{
\item{base}{List of paired arrays or excel path containing the properly formatted paired arrays.}

\item{map}{Vector containing the number of subscriptions of each criteria, from left to right. map = rep(0,n) n = number of criteria and no subcriteria;
mapeamento = c(1,2) for one subcriteria in criteria 1 and two subcriteria in criteria 2. If in doubt, see the tutorial vignette.}
}
\value{
Table containing the relationships of criteria, subscriptions (If any) and Alternatives Using the AHP system.
}
\description{
Calculates AHP in a list of paired arrays or in a properly formatted excel worksheet stipend.
}
\examples{
x=paste0(letters[3],1:5)
y=c(5,2,7,3,2)
m1=matrix_ahp(x,y)
x=paste0(letters[1],1:3)
y=c(4.4,5.2,3)
m2=matrix_ahp(x,y)
y=c(2,4,3)
m3=matrix_ahp(x,y)
y=c(4.9,5,3.3)
m4=matrix_ahp(x,y)
y=c(4.4,4.2,4.3)
m5=matrix_ahp(x,y)
y=c(5.4,5.2,5.7)
m6=matrix_ahp(x,y)
base=list(m1, m2, m3, m4, m5, m6)
map = rep(0,5)
ahp_s(base,map)

#with two subcriteria in criteria 1 and 2 alternatives
map = c(2,0,0)
x=paste0(letters[3],1:3) #3 criteria
y=c(5,2,7)
m1=matrix_ahp(x,y) # matrix compare three criteria
x=paste0("SC1",1:2)
y=c(4,6)
m2=matrix_ahp(x,y) # 2 matrix compare two subcriteria of criteria 1
x=paste0(letters[1],1:2)
y=c(2,4)
m3=matrix_ahp(x,y) #alternatives for subcriteria 1
y=c(4.9,5)
m4=matrix_ahp(x,y) #alternatives for subcriteria 2
y=c(4.4,4.2)
m5=matrix_ahp(x,y) #alternatives for criteria 2
y=c(5.4,5.2)
m6=matrix_ahp(x,y) ##alternatives for criteria 3
base=list(m1, m2, m3, m4, m5, m6)


ahp_s(base,map)

#Other mapeamento: criteria 2 with 2 subcriteria and 3 alternatives


map = c(2,2)
x=paste0(letters[3],1:2) #2 criteria
y=c(5,7)
m1=matrix_ahp(x,y) # matrix compare two criteria
x=paste0("SC1",1:2)
y=c(4,6)
m2=matrix_ahp(x,y) # matrix compare two subcriteria of criteria 1
x=paste0(letters[1],1:3)
y=c(2,4,5)
m3=matrix_ahp(x,y) #alternatives for subcriteria 1 - criteria 1
y=c(4.9,5, 2)
m4=matrix_ahp(x,y) #alternatives for subcriteria 2 - criteria 1
y=c(4.4,8)
x=paste0("SC2",1:2)
m5=matrix_ahp(x,y) #matrix compare two subcriteria of criteria 2
y=c(5.4,5.2, 1)
x=paste0(letters[1],1:3)
m6=matrix_ahp(x,y) #alternatives for subcriteria 1 - criteria 2
y=c(9,5.2, 3)
m7=matrix_ahp(x,y) #alternatives for subcriteria 2 - criteria 2
base=list(m1, m2, m3, m4, m5, m6, m7)

ahp_s(base,map)

}
\author{
Luciane Ferreira Alcoforado
}
